/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public class ApplyTemplates
extends Instruction {
    private Expression select;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;
    private boolean backwardsCompatible;
    private static InstructionDetails builtInDetails = new InstructionDetails();

    public ApplyTemplates(Expression expression, boolean bl, boolean bl2, Mode mode, boolean bl3) {
        this.select = expression;
        this.useCurrentMode = bl;
        this.useTailRecursion = bl2;
        this.mode = mode;
        this.backwardsCompatible = bl3;
    }

    public void setActualParameters(WithParam[] withParamArray, WithParam[] withParamArray2) {
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
    }

    public int getInstructionNameCode() {
        return 130;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        instructionDetails.setProperty("mode", this.mode);
        return instructionDetails;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        WithParam.simplify(this.actualParams, staticContext);
        WithParam.simplify(this.tunnelParams, staticContext);
        this.select = this.select.simplify(staticContext);
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        WithParam.analyze(this.actualParams, staticContext, itemType);
        WithParam.analyze(this.tunnelParams, staticContext, itemType);
        this.select = this.select.analyze(staticContext, itemType);
        if (this.select instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        return this;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        this.apply(xPathContext, false);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        return this.apply(xPathContext, this.useTailRecursion);
    }

    private TailCall apply(XPathContext xPathContext, boolean bl) throws XPathException {
        Mode mode = this.mode;
        if (this.useCurrentMode) {
            mode = xPathContext.getCurrentMode();
        }
        ParameterSet parameterSet = ApplyTemplates.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = ApplyTemplates.assembleTunnelParams(xPathContext, this.tunnelParams);
        if (bl) {
            XPathContextMajor xPathContextMajor = xPathContext.newContext();
            xPathContextMajor.setOrigin(this);
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.select, xPathContext, false), mode, parameterSet, parameterSet2, xPathContextMajor, this.getLocationId());
        }
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return null;
        }
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        try {
            for (TailCall tailCall = ApplyTemplates.applyTemplates(sequenceIterator, mode, parameterSet, parameterSet2, xPathContextMajor, this.backwardsCompatible, this.getLocationId()); tailCall != null; tailCall = tailCall.processLeavingTail(xPathContextMajor)) {
            }
        }
        catch (StackOverflowError stackOverflowError) {
            DynamicError dynamicError = new DynamicError("Too many nested apply-templates calls. The stylesheet is probably looping.");
            dynamicError.setErrorCode("SXLM0001");
            dynamicError.setLocator(this);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        return null;
    }

    public static TailCall applyTemplates(SequenceIterator sequenceIterator, Mode mode, ParameterSet parameterSet, ParameterSet parameterSet2, XPathContextMajor xPathContextMajor, boolean bl, int n) throws XPathException {
        Controller controller = xPathContextMajor.getController();
        TailCall tailCall = null;
        XPathContextMajor xPathContextMajor2 = xPathContextMajor;
        if (controller.isTracing()) {
            xPathContextMajor2.setCurrentIterator(sequenceIterator);
            xPathContextMajor2.setCurrentMode(mode);
            while (true) {
                if (tailCall != null) {
                    tailCall = tailCall.processLeavingTail(xPathContextMajor2);
                    continue;
                }
                NodeInfo nodeInfo = (NodeInfo)sequenceIterator.next();
                if (nodeInfo != null) {
                    TraceListener traceListener;
                    Template template = controller.getRuleManager().getTemplateRule(nodeInfo, mode, xPathContextMajor2);
                    if (template == null) {
                        ApplyTemplates.defaultAction(nodeInfo, parameterSet, parameterSet2, xPathContextMajor2, bl, n);
                        continue;
                    }
                    if (parameterSet2 != null || template.needsStackFrame()) {
                        traceListener = controller.getTraceListener();
                        xPathContextMajor2.setLocalParameters(parameterSet);
                        xPathContextMajor2.setTunnelParameters(parameterSet2);
                        xPathContextMajor2.openStackFrame(template.getStackFrameMap());
                        traceListener.startCurrentItem(nodeInfo);
                        tailCall = template.processLeavingTail(xPathContextMajor2);
                        traceListener.endCurrentItem(nodeInfo);
                        continue;
                    }
                    traceListener = controller.getTraceListener();
                    traceListener.startCurrentItem(nodeInfo);
                    tailCall = template.processLeavingTail(xPathContextMajor2);
                    traceListener.endCurrentItem(nodeInfo);
                    continue;
                }
                break;
            }
        } else {
            xPathContextMajor2.setCurrentIterator(sequenceIterator);
            xPathContextMajor2.setCurrentMode(mode);
            while (true) {
                if (tailCall != null) {
                    tailCall = tailCall.processLeavingTail(xPathContextMajor2);
                    continue;
                }
                NodeInfo nodeInfo = (NodeInfo)sequenceIterator.next();
                if (nodeInfo == null) break;
                Template template = controller.getRuleManager().getTemplateRule(nodeInfo, mode, xPathContextMajor2);
                if (template == null) {
                    ApplyTemplates.defaultAction(nodeInfo, parameterSet, parameterSet2, xPathContextMajor2, bl, n);
                    continue;
                }
                if (parameterSet2 != null || template.needsStackFrame()) {
                    xPathContextMajor2.openStackFrame(template.getStackFrameMap());
                    xPathContextMajor2.setLocalParameters(parameterSet);
                    xPathContextMajor2.setTunnelParameters(parameterSet2);
                    tailCall = template.processLeavingTail(xPathContextMajor2);
                    continue;
                }
                tailCall = template.processLeavingTail(xPathContextMajor2);
            }
        }
        return tailCall;
    }

    public static void defaultAction(NodeInfo nodeInfo, ParameterSet parameterSet, ParameterSet parameterSet2, XPathContext xPathContext, boolean bl, int n) throws XPathException {
        switch (nodeInfo.getNodeKind()) {
            case 1: 
            case 9: {
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3);
                XPathContextMajor xPathContextMajor = xPathContext.newContext();
                xPathContextMajor.setOrigin(builtInDetails);
                for (TailCall tailCall = ApplyTemplates.applyTemplates(axisIterator, xPathContext.getCurrentMode(), parameterSet, parameterSet2, xPathContextMajor, bl, n); tailCall != null; tailCall = tailCall.processLeavingTail(xPathContextMajor)) {
                }
                return;
            }
            case 2: 
            case 3: {
                xPathContext.getReceiver().characters(nodeInfo.getStringValueCS(), n, 0);
                return;
            }
            case 7: 
            case 8: 
            case 13: {
                return;
            }
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        arrayList.add(this.select);
        WithParam.getXPathExpressions(this.actualParams, arrayList);
        WithParam.getXPathExpressions(this.tunnelParams, arrayList);
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.select.promote(promotionOffer);
        WithParam.promoteParams(this.actualParams, promotionOffer);
        WithParam.promoteParams(this.tunnelParams, promotionOffer);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "apply-templates " + "select=");
        this.select.display(n + 1, namePool, printStream);
    }

    static {
        builtInDetails.setConstructType(2010);
    }

    private static class ApplyTemplatesPackage
    implements TailCall {
        private ValueRepresentation selectedNodes;
        private Mode mode;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContextMajor evaluationContext;
        private int locationId;

        ApplyTemplatesPackage(ValueRepresentation valueRepresentation, Mode mode, ParameterSet parameterSet, ParameterSet parameterSet2, XPathContextMajor xPathContextMajor, int n) {
            this.selectedNodes = valueRepresentation;
            this.mode = mode;
            this.params = parameterSet;
            this.tunnelParams = parameterSet2;
            this.evaluationContext = xPathContextMajor;
            this.locationId = n;
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
            TailCall tailCall = ApplyTemplates.applyTemplates(Value.getIterator(this.selectedNodes), this.mode, this.params, this.tunnelParams, this.evaluationContext, false, this.locationId);
            return tailCall;
        }
    }
}

