/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;

public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType contextItemType;

    public Copy(boolean bl, boolean bl2, SchemaType schemaType, int n) {
        this.copyNamespaces = bl;
        this.inheritNamespaces = bl2;
        this.schemaType = schemaType;
        this.validation = n;
    }

    public int getInstructionNameCode() {
        return 139;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.setLazyConstruction(staticContext.getConfiguration().isLazyConstructionMode());
        this.contextItemType = itemType;
        Expression expression = super.analyze(staticContext, itemType);
        this.verifyLazyConstruction();
        return expression;
    }

    public ItemType getItemType() {
        if (this.contextItemType == null) {
            return AnyItemType.getInstance();
        }
        return this.contextItemType;
    }

    public int getNameCode(XPathContext xPathContext) throws XPathException {
        return ((NodeInfo)xPathContext.getContextItem()).getNameCode();
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
        if (this.copyNamespaces) {
            NodeInfo nodeInfo = (NodeInfo)xPathContext.getContextItem();
            nodeInfo.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getActiveNamespaces() throws XPathException {
        if (this.copyNamespaces) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
        Item item = xPathContext.getContextItem();
        if (!(item instanceof NodeInfo)) {
            sequenceReceiver.append(item, this.locationId, 2);
            return null;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(xPathContextMinor);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, this.locationId, xPathContextMinor);
                    break;
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    noOpenStartTagException.setXPathContext(xPathContext);
                    throw Copy.dynamicError(this, noOpenStartTagException, xPathContextMinor);
                }
            }
            case 3: {
                sequenceReceiver.characters(nodeInfo.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 7: {
                sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 8: {
                sequenceReceiver.comment(nodeInfo.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    nodeInfo.copy(sequenceReceiver, 0, false, this.locationId);
                    break;
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode(noOpenStartTagException.getErrorCodeLocalPart());
                    throw Copy.dynamicError(this, dynamicError, xPathContext);
                }
            }
            case 9: {
                Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), controller.getNamePool(), this.validation);
                if (receiver != sequenceReceiver) {
                    TreeReceiver treeReceiver = new TreeReceiver(receiver);
                    treeReceiver.setPipelineConfiguration(sequenceReceiver.getPipelineConfiguration());
                    xPathContextMinor.setReceiver(treeReceiver);
                    receiver = treeReceiver;
                }
                receiver.startDocument(0);
                this.content.process(xPathContextMinor);
                receiver.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceOutputter sequenceOutputter = new SequenceOutputter(1);
        sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        this.process(xPathContextMinor);
        sequenceOutputter.close();
        return sequenceOutputter.getFirstItem();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "copy");
    }
}

