/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pull.UnconstructedElement;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ValidationException;

public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespaces = true;

    public ItemType getItemType() {
        return NodeKindTest.ELEMENT;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public void setValidationMode(int n) {
        this.validation = n;
    }

    public int getValidationMode() {
        return this.validation;
    }

    public abstract int getNameCode(XPathContext var1) throws XPathException;

    protected abstract void outputNamespaceNodes(XPathContext var1, Receiver var2) throws XPathException;

    public int[] getActiveNamespaces() throws XPathException {
        return null;
    }

    public int getImplementationMethod() {
        return 5;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        try {
            int n = this.getNameCode(xPathContext);
            if (n == -1) {
                this.skipElement(xPathContext);
                return null;
            }
            Controller controller = xPathContext.getController();
            XPathContext xPathContext2 = xPathContext;
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            Receiver receiver = controller.getConfiguration().getElementValidator(sequenceReceiver, n, this.locationId, this.schemaType, this.validation, controller.getNamePool());
            if (receiver != sequenceReceiver) {
                xPathContext2 = xPathContext.newMinorContext();
                xPathContext2.setOrigin(this);
                sequenceReceiver = new TreeReceiver(receiver);
                sequenceReceiver.setPipelineConfiguration(controller.makePipelineConfiguration());
                xPathContext2.setReceiver(sequenceReceiver);
            }
            int n2 = this.inheritNamespaces ? 0 : 128;
            sequenceReceiver.startElement(n, -1, this.locationId, n2);
            this.outputNamespaceNodes(xPathContext2, sequenceReceiver);
            this.content.process(xPathContext2);
            sequenceReceiver.endElement();
            return null;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    private void skipElement(XPathContext xPathContext) throws XPathException {
        xPathContext.getReceiver().startElement(-1, -1, this.locationId, 0);
        this.content.process(xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.isLazyConstruction()) {
            UnconstructedElement unconstructedElement = new UnconstructedElement(this, xPathContext);
            unconstructedElement.setNameCode(this.getNameCode(xPathContext));
            return unconstructedElement;
        }
        return this.constructElement(xPathContext);
    }

    private NodeInfo constructElement(XPathContext xPathContext) throws XPathException {
        try {
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContextMinor.setOrigin(this);
            SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
            SequenceOutputter sequenceOutputter = sequenceReceiver instanceof SequenceOutputter && !((SequenceOutputter)sequenceReceiver).hasOpenNodes() ? (SequenceOutputter)sequenceReceiver : new SequenceOutputter(1);
            sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            int n = this.getNameCode(xPathContextMinor);
            Receiver receiver = controller.getConfiguration().getElementValidator(sequenceOutputter, n, this.locationId, this.schemaType, this.validation, controller.getNamePool());
            SequenceReceiver sequenceReceiver2 = sequenceOutputter;
            if (receiver == sequenceOutputter) {
                xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
            } else {
                TreeReceiver treeReceiver = new TreeReceiver(receiver);
                treeReceiver.setPipelineConfiguration(sequenceOutputter.getPipelineConfiguration());
                xPathContextMinor.setReceiver(treeReceiver);
                sequenceReceiver2 = treeReceiver;
            }
            sequenceReceiver2.open();
            int n2 = this.inheritNamespaces ? 0 : 128;
            sequenceReceiver2.startElement(n, -1, this.locationId, n2);
            this.outputNamespaceNodes(xPathContextMinor, sequenceReceiver2);
            this.content.process(xPathContextMinor);
            sequenceReceiver2.endElement();
            sequenceReceiver2.close();
            return (NodeInfo)sequenceOutputter.popLastItem();
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof ValidationException) {
                ((ValidationException)xPathException).setSourceLocator(this);
                ((ValidationException)xPathException).setSystemId(this.getSystemId());
            }
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            if (xPathException instanceof DynamicError && ((DynamicError)xPathException).getXPathContext() == null) {
                ((DynamicError)xPathException).setXPathContext(xPathContext);
            }
            throw xPathException;
        }
    }
}

