/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class FixedElement
extends ElementCreator {
    private int nameCode;
    protected int[] namespaceCodes = null;
    private ItemType itemType;

    public FixedElement(int n, int[] nArray, boolean bl, SchemaType schemaType, int n2) {
        this.nameCode = n;
        this.namespaceCodes = nArray;
        this.inheritNamespaces = bl;
        this.schemaType = schemaType;
        this.validation = n2;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        instructionDetails.setConstructType(2006);
        instructionDetails.setObjectNameCode(this.nameCode);
        return instructionDetails;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.setLazyConstruction(staticContext.getConfiguration().isLazyConstructionMode());
        if (this.schemaType == null) {
            if (this.validation == 1) {
                SchemaDeclaration schemaDeclaration = staticContext.getConfiguration().getElementDeclaration(this.nameCode & 0xFFFFF);
                if (schemaDeclaration == null) {
                    StaticError staticError = new StaticError("There is no global element declaration for " + staticContext.getNamePool().getDisplayName(this.nameCode) + ", so strict validation will fail");
                    staticError.setIsTypeError(true);
                    staticError.setLocator(this);
                    throw staticError;
                }
                this.schemaType = schemaDeclaration.getType();
                this.itemType = new CombinedNodeTest(new NameTest(1, this.nameCode, staticContext.getNamePool()), 23, new ContentTypeTest(1, this.schemaType, staticContext.getConfiguration()));
            } else if (this.validation == 2) {
                SchemaDeclaration schemaDeclaration = staticContext.getConfiguration().getElementDeclaration(this.nameCode & 0xFFFFF);
                if (schemaDeclaration == null) {
                    staticContext.issueWarning("There is no global element declaration for " + staticContext.getNamePool().getDisplayName(this.nameCode) + ", so lax validation has no effect", this);
                    this.itemType = new CombinedNodeTest(new NameTest(1, this.nameCode, staticContext.getNamePool()), 23, new ContentTypeTest(1, BuiltInSchemaFactory.getSchemaType(641), staticContext.getConfiguration()));
                } else {
                    this.schemaType = schemaDeclaration.getType();
                    this.itemType = new CombinedNodeTest(new NameTest(1, this.nameCode, staticContext.getNamePool()), 23, new ContentTypeTest(1, this.schemaType, staticContext.getConfiguration()));
                }
            } else {
                this.itemType = new CombinedNodeTest(new NameTest(1, this.nameCode, staticContext.getNamePool()), 23, new ContentTypeTest(1, BuiltInSchemaFactory.getSchemaType(641), staticContext.getConfiguration()));
            }
        } else {
            this.itemType = new CombinedNodeTest(new NameTest(1, this.nameCode, staticContext.getNamePool()), 23, new ContentTypeTest(1, this.schemaType, staticContext.getConfiguration()));
        }
        return super.simplify(staticContext);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.schemaType != null) {
            try {
                this.schemaType.analyzeContentExpression(this.content, 1, staticContext);
            }
            catch (ValidationException validationException) {
                if (validationException.getLocator().getLineNumber() == 1) {
                    validationException.setLocator(this);
                }
                throw validationException;
            }
        }
        Expression expression = super.analyze(staticContext, itemType);
        this.verifyLazyConstruction();
        return expression;
    }

    public ItemType getItemType() {
        if (this.itemType == null) {
            return super.getItemType();
        }
        return this.itemType;
    }

    public int getNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        SchemaType schemaType2;
        if (schemaType instanceof SimpleType) {
            StaticError staticError = new StaticError("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element is of simple type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (((ComplexType)schemaType).isSimpleContent()) {
            StaticError staticError = new StaticError("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element has a complex type with simple content");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        try {
            schemaType2 = ((ComplexType)schemaType).getElementParticleType(this.nameCode & 0xFFFFF);
        }
        catch (SchemaException schemaException) {
            throw new StaticError(schemaException);
        }
        if (schemaType2 == null) {
            if (schemaType.allowsDerivation(2)) {
                staticContext.issueWarning("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + schemaType.getDescription() + ". Validation will fail unless there is an extended type that permits this element", this);
                return;
            }
            StaticError staticError = new StaticError("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (schemaType2 instanceof AnyType) {
            return;
        }
        try {
            this.content.checkPermittedContents(schemaType2, staticContext, true);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null || xPathException.getLocator() == xPathException) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
        if (this.namespaceCodes != null) {
            for (int i = 0; i < this.namespaceCodes.length; ++i) {
                receiver.namespace(this.namespaceCodes[i], 0);
            }
        }
    }

    public int[] getActiveNamespaces() throws XPathException {
        return this.namespaceCodes;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "element ");
        printStream.println(ExpressionTool.indent(n + 1) + "name " + (namePool == null ? this.nameCode + "" : namePool.getDisplayName(this.nameCode)));
        printStream.println(ExpressionTool.indent(n + 1) + "content");
        this.content.display(n + 1, namePool, printStream);
    }
}

