/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class Namespace
extends SimpleNodeConstructor {
    private Expression name;

    public Namespace(Expression expression) {
        this.name = expression;
    }

    public int getInstructionNameCode() {
        return 161;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.name = this.name.simplify(staticContext);
        return super.simplify(staticContext);
    }

    public ItemType getItemType() {
        return NodeKindTest.NAMESPACE;
    }

    public int getCardinality() {
        return 16384;
    }

    protected void promoteInst(PromotionOffer promotionOffer) {
    }

    public void typeCheck(StaticContext staticContext, ItemType itemType) {
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        arrayList.add(this.name);
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        String string = this.name.evaluateAsString(xPathContext);
        if (!string.equals("") && !XMLChar.isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Namespace prefix is invalid: " + string, this);
            dynamicError.setErrorCode("XTDE0920");
            dynamicError.setXPathContext(xPathContext);
            throw Namespace.dynamicError(this, dynamicError, xPathContext);
        }
        if (string.equals("xmlns")) {
            DynamicError dynamicError = new DynamicError("Namespace prefix 'xmlns' is not allowed", this);
            dynamicError.setErrorCode("XTDE0920");
            dynamicError.setXPathContext(xPathContext);
            throw Namespace.dynamicError(this, dynamicError, xPathContext);
        }
        String string2 = ((Object)this.expandChildren(xPathContext)).toString();
        if (string.equals("xml") != string2.equals("http://www.w3.org/XML/1998/namespace")) {
            DynamicError dynamicError = new DynamicError("Namespace prefix 'xml' and namespace uri http://www.w3.org/XML/1998/namespace must only be used together", this);
            dynamicError.setErrorCode("XTDE0925");
            dynamicError.setXPathContext(xPathContext);
            throw Namespace.dynamicError(this, dynamicError, xPathContext);
        }
        if (string2.equals("")) {
            DynamicError dynamicError = new DynamicError("Namespace URI is an empty string", this);
            dynamicError.setErrorCode("XTDE0930");
            dynamicError.setXPathContext(xPathContext);
            throw Namespace.dynamicError(this, dynamicError, xPathContext);
        }
        int n = controller.getNamePool().allocateNamespaceCode(string, string2);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        sequenceReceiver.namespace(n, 32);
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "namespace");
        this.name.display(n + 1, namePool, printStream);
        super.display(n + 1, namePool, printStream);
    }
}

