/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;

public abstract class ParentNodeConstructor
extends Instruction {
    protected Expression content;
    private boolean lazyConstruction = false;
    int validation = 3;
    SchemaType schemaType;

    public void setLazyConstruction(boolean bl) {
        this.lazyConstruction = bl;
    }

    public final boolean isLazyConstruction() {
        return this.lazyConstruction;
    }

    public int getValidationAction() {
        return this.validation;
    }

    public void setContentExpression(Expression expression) {
        this.content = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.content = this.content.simplify(staticContext);
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.analyze(staticContext, itemType);
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.content = this.content.promote(promotionOffer);
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.content);
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int getCardinality() {
        return 16384;
    }

    void verifyLazyConstruction() {
        if (!this.isLazyConstruction()) {
            return;
        }
        if ((this.getDependencies() & 0xC) != 0) {
            this.setLazyConstruction(false);
        }
        if (this.validation == 1 || this.validation == 2 || this.schemaType != null) {
            this.setLazyConstruction(false);
        }
    }
}

