/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Value;

public class ResultDocument
extends Instruction {
    private Expression href;
    private Expression content;
    private Properties outputProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;
    private HashMap serializationAttributes;
    private NamespaceResolver nsResolver;

    public ResultDocument(Properties properties, Expression expression, String string, int n, SchemaType schemaType, HashMap hashMap, NamespaceResolver namespaceResolver) {
        this.outputProperties = properties;
        this.href = expression;
        this.baseURI = string;
        this.validationAction = n;
        this.schemaType = schemaType;
        this.serializationAttributes = hashMap;
        this.nsResolver = namespaceResolver;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            this.adoptChildExpression((Expression)iterator.next());
        }
    }

    public void setContent(Expression expression) {
        this.content = expression;
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.content = this.content.simplify(staticContext);
        if (this.href != null) {
            this.href = this.href.simplify(staticContext);
        }
        Iterator iterator = this.serializationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(k);
            if (expression instanceof Value) continue;
            expression = expression.simplify(staticContext);
            this.serializationAttributes.put(k, expression);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.analyze(staticContext, itemType);
        if (this.href != null) {
            this.href = this.href.analyze(staticContext, itemType);
        }
        Iterator iterator = this.serializationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(k);
            if (expression instanceof Value) continue;
            expression = expression.analyze(staticContext, itemType);
            this.serializationAttributes.put(k, expression);
        }
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.content = this.content.promote(promotionOffer);
        if (this.href != null) {
            this.href = this.href.promote(promotionOffer);
        }
        Iterator iterator = this.serializationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(k);
            if (expression instanceof Value) continue;
            expression = expression.promote(promotionOffer);
            this.serializationAttributes.put(k, expression);
        }
    }

    public int getInstructionNameCode() {
        return 174;
    }

    public ItemType getItemType() {
        return NoNodeTest.getInstance();
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        arrayList.add(this.content);
        if (this.href != null) {
            arrayList.add(this.href);
        }
        Iterator iterator = this.serializationAttributes.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add((Expression)iterator.next());
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Result result;
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        OutputURIResolver outputURIResolver = null;
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                outputURIResolver = controller.getOutputURIResolver();
                object4 = this.href.evaluateAsString(xPathContext);
                result = outputURIResolver.resolve((String)object4, controller.getBaseOutputURI());
                if (result == null) {
                    outputURIResolver = StandardOutputResolver.getInstance();
                    result = outputURIResolver.resolve((String)object4, controller.getBaseOutputURI());
                }
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
        }
        if (!controller.checkUniqueOutputDestination(result.getSystemId())) {
            object4 = new DynamicError("Cannot write more than one result document to the same URI: " + result.getSystemId());
            ((DynamicError)object4).setXPathContext(xPathContext);
            ((XPathException)object4).setErrorCode("XTDE1490");
            throw object4;
        }
        boolean bl = controller.getConfiguration().isTiming();
        if (bl) {
            object3 = result.getSystemId();
            if (object3 == null) {
                object3 = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            System.err.println("Writing to " + (String)object3);
        }
        object3 = this.outputProperties;
        if (this.serializationAttributes.size() > 0) {
            object3 = new Properties(this.outputProperties);
            object2 = xPathContext.getController().getNamePool();
            object = this.serializationAttributes.keySet().iterator();
            while (object.hasNext()) {
                Integer n = (Integer)object.next();
                Expression expression = (Expression)this.serializationAttributes.get(n);
                String string = expression.evaluateAsString(xPathContext);
                try {
                    ResultDocument.setSerializationProperty((Properties)object3, n, string, (NamePool)object2, this.nsResolver);
                }
                catch (DynamicError dynamicError) {
                    if ("http://saxon.sf.net/".equals(dynamicError.getErrorCodeNamespace()) && "warning".equals(dynamicError.getErrorCodeLocalPart())) {
                        try {
                            xPathContext.getController().getErrorListener().warning(dynamicError);
                            continue;
                        }
                        catch (TransformerException transformerException) {
                            throw DynamicError.makeDynamicError(transformerException);
                        }
                    }
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setLocator(this.getSourceLocator());
                    throw dynamicError;
                }
            }
        }
        if ((object2 = this.outputProperties.getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            try {
                result = controller.prepareNextStylesheet((String)object2, this.baseURI, result);
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
        }
        xPathContextMinor.changeOutputDestination((Properties)object3, result, true, this.validationAction, this.schemaType);
        object = xPathContextMinor.getReceiver();
        object.startDocument(0);
        this.content.process(xPathContextMinor);
        object.endDocument();
        object.close();
        if (outputURIResolver != null) {
            try {
                outputURIResolver.close(result);
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSerializationProperty(Properties properties, int n, String string, NamePool namePool, NamespaceResolver namespaceResolver) throws XPathException {
        String string2;
        block41: {
            String string3;
            String string4;
            block40: {
                string4 = namePool.getLocalName(n);
                string3 = namePool.getURI(n);
                if (!string3.equals("")) break block40;
                if (string4.equals("method")) {
                    if (string.equals("xml") || string.equals("html") || string.equals("text") || string.equals("xhtml")) {
                        properties.put("method", string);
                        return;
                    }
                    try {
                        String[] stringArray = Name.getQNameParts(string);
                        String string5 = stringArray[0];
                        if (string5.equals("")) {
                            DynamicError dynamicError = new DynamicError("method must be xml, html, xhtml, or text, or a prefixed name");
                            dynamicError.setErrorCode("XTSE1570");
                            throw dynamicError;
                        }
                        String string6 = namespaceResolver.getURIForPrefix(string5, false);
                        if (string6 == null) {
                            DynamicError dynamicError = new DynamicError("Namespace prefix '" + string5 + "' has not been declared");
                            dynamicError.setErrorCode("XTSE1570");
                            throw dynamicError;
                        }
                        properties.put("method", '{' + string6 + '}' + stringArray[1]);
                        return;
                    }
                    catch (QNameException qNameException) {
                        DynamicError dynamicError = new DynamicError("Invalid method name. " + qNameException.getMessage());
                        dynamicError.setErrorCode("XTSE1570");
                        throw dynamicError;
                    }
                }
                if (string4.equals("output-version")) {
                    properties.put("version", string);
                    return;
                }
                if (string4.equals("byte-order-mark")) {
                    if (!string.equals("yes") && !string.equals("no")) {
                        DynamicError dynamicError = new DynamicError("byte-order-mark value must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("byte-order-mark", string);
                    return;
                }
                if (string4.equals("indent")) {
                    if (!string.equals("yes") && !string.equals("no")) {
                        DynamicError dynamicError = new DynamicError("indent must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("indent", string);
                    return;
                }
                if (string4.equals("encoding")) {
                    properties.put("encoding", string);
                    return;
                }
                if (string4.equals("media-type")) {
                    properties.put("media-type", string);
                    return;
                }
                if (string4.equals("doctype-system")) {
                    properties.put("doctype-system", string);
                    return;
                }
                if (string4.equals("doctype-public")) {
                    properties.put("doctype-public", string);
                    return;
                }
                if (string4.equals("omit-xml-declaration")) {
                    if (!string.equals("yes") && !string.equals("no")) {
                        DynamicError dynamicError = new DynamicError("omit-xml-declaration attribute must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("omit-xml-declaration", string);
                    return;
                }
                if (string4.equals("standalone")) {
                    if (!string.equals("yes") && !string.equals("no")) {
                        if (!string.equals("omit")) return;
                    }
                    properties.put("standalone", string);
                    DynamicError dynamicError = new DynamicError("standalone attribute must be 'yes' or 'no' or 'omit'");
                    dynamicError.setErrorCode("XTDE0030");
                    throw dynamicError;
                }
                if (string4.equals("cdata-section-elements")) {
                    string2 = properties.getProperty("cdata-section-elements");
                    if (string2 == null) {
                        string2 = "";
                    }
                    break block41;
                } else {
                    if (string4.equals("use-character-maps")) {
                        String string7 = properties.getProperty("use-character-maps");
                        if (string7 == null) {
                            string7 = "";
                        }
                        properties.put("use-character-maps", string7 + string);
                        return;
                    }
                    if (string4.equals("undeclare-prefixes")) {
                        if (!string.equals("yes") && !string.equals("no")) {
                            DynamicError dynamicError = new DynamicError("undeclare-namespaces value must be 'yes' or 'no'");
                            dynamicError.setErrorCode("XTDE0030");
                            throw dynamicError;
                        }
                        properties.put("undeclare-prefixes", string);
                        return;
                    }
                    if (string4.equals("include-content-type")) {
                        if (!string.equals("yes") && !string.equals("no")) {
                            DynamicError dynamicError = new DynamicError("include-content-type attribute must be 'yes' or 'no'");
                            dynamicError.setErrorCode("XTDE0030");
                            throw dynamicError;
                        }
                        properties.put("include-content-type", string);
                        return;
                    }
                    if (!string4.equals("escape-uri-attributes")) return;
                    if (!string.equals("yes") && !string.equals("no")) {
                        DynamicError dynamicError = new DynamicError("escape-uri-attributes value must be 'yes' or 'no'");
                        dynamicError.setErrorCode("XTDE0030");
                        throw dynamicError;
                    }
                    properties.put("escape-uri-attibutes", string);
                    return;
                }
            }
            if (!string3.equals("http://saxon.sf.net/")) {
                properties.put('{' + string3 + '}' + string4, string);
                return;
            }
            if (string4.equals("character-representation")) {
                properties.put("{http://saxon.sf.net/}character-representation", string);
                return;
            }
            if (string4.equals("indent-spaces")) {
                try {
                    Integer.parseInt(string);
                    properties.put("indent", "yes");
                    properties.put("{http://saxon.sf.net/}indent-spaces", string);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    DynamicError dynamicError = new DynamicError("saxon:indent-spaces must be an integer");
                    dynamicError.setErrorCode("http://saxon.sf.net/", "SXWN9002");
                    throw dynamicError;
                }
            }
            if (string4.equals("next-in-chain")) {
                DynamicError dynamicError = new DynamicError("saxon:next-in-chain value cannot be specified dynamically");
                dynamicError.setErrorCode("http://saxon.sf.net/", "SXWN9004");
                throw dynamicError;
            }
            if (!string4.equals("require-well-formed")) return;
            if (!string.equals("yes") && !string.equals("no")) {
                DynamicError dynamicError = new DynamicError("saxon:require-well-formed value must be 'yes' or 'no'");
                dynamicError.setErrorCode("http://saxon.sf.net/", "SXWN9003");
                throw dynamicError;
            }
            properties.put("{http://saxon.sf.net/}require-well-formed", string);
            return;
        }
        String string8 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string9 = stringTokenizer.nextToken();
            try {
                String[] stringArray = Name.getQNameParts(string9);
                object = namespaceResolver.getURIForPrefix(stringArray[0], true);
                if (object == null) {
                    DynamicError dynamicError = new DynamicError("Namespace prefix '" + stringArray[0] + "' has not been declared");
                    dynamicError.setErrorCode("XT0030");
                    throw dynamicError;
                }
                string8 = string8 + " {" + (String)object + '}' + stringArray[1];
            }
            catch (QNameException qNameException) {
                object = new DynamicError("Invalid CDATA element name. " + qNameException.getMessage());
                ((XPathException)object).setErrorCode("XTDE0030");
                throw object;
            }
            properties.put("cdata-section-elements", string2 + string8);
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "result-document");
        this.content.display(n + 1, namePool, printStream);
    }
}

