/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean isNumberingInstruction = false;

    public ValueOf(Expression expression, boolean bl) {
        this.select = expression;
        this.options = bl ? 1 : 0;
        this.adoptChildExpression(expression);
    }

    public void setIsNumberingInstruction() {
        this.isNumberingInstruction = true;
    }

    public int getInstructionNameCode() {
        if (this.isNumberingInstruction) {
            return 160;
        }
        if (this.select instanceof StringValue) {
            return 182;
        }
        return 184;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        super.promoteInst(promotionOffer);
    }

    public ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    public int getCardinality() {
        return 16384;
    }

    public void typeCheck(StaticContext staticContext, ItemType itemType) {
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (this.select instanceof Value) {
            SimpleType simpleType = null;
            if (schemaType instanceof SimpleType && bl) {
                simpleType = (SimpleType)schemaType;
            } else if (schemaType instanceof ComplexType && ((ComplexType)schemaType).isSimpleContent()) {
                simpleType = ((ComplexType)schemaType).getSimpleContentType();
            }
            if (bl && simpleType != null && !simpleType.isNamespaceSensitive()) {
                ValidationException validationException = simpleType.validateContent(((Value)this.select).getStringValue(), null, staticContext.getConfiguration());
                if (validationException != null) {
                    validationException.setLocator(this);
                    throw validationException;
                }
                return;
            }
            if (schemaType instanceof ComplexType && !((ComplexType)schemaType).isSimpleContent() && !((ComplexType)schemaType).isMixedContent() && !Navigator.isWhite(((Value)this.select).getStringValue())) {
                StaticError staticError = new StaticError("Complex type " + schemaType.getDescription() + " does not allow text content " + Err.wrap(((Value)this.select).getStringValue()));
                staticError.setLocator(this);
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        sequenceReceiver.characters(this.expandChildren(xPathContext), this.locationId, this.options);
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            CharSequence charSequence = this.expandChildren(xPathContext);
            Orphan orphan = new Orphan(xPathContext.getController().getConfiguration());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            return orphan;
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "value-of");
        this.select.display(n + 1, namePool, printStream);
    }
}

