/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class While
extends Instruction {
    private Expression test;
    private Expression action;

    public While(Expression expression, Expression expression2) {
        this.test = expression;
        this.action = expression2;
    }

    public int getInstructionNameCode() {
        return 264;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.test = this.test.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.test = this.test.analyze(staticContext, itemType);
        this.action = this.action.analyze(staticContext, itemType);
        return this;
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.test = this.test.promote(promotionOffer);
        this.action = this.action.promote(promotionOffer);
    }

    public final boolean createsNewNodes() {
        int n = this.action.getSpecialProperties();
        return (n & 0x400000) == 0;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.test, this.action);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        while (this.test.effectiveBooleanValue(xPathContext)) {
            this.action.process(xPathContext);
        }
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "while");
        this.test.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "do");
        this.action.display(n + 1, namePool, printStream);
    }
}

