/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;

public final class ReverseArrayIterator
implements AxisIterator,
ReversibleIterator,
LastPositionFinder {
    Item[] items;
    int index = 0;
    int start;
    int end;
    Item current = null;

    public ReverseArrayIterator(Item[] itemArray, int n, int n2) {
        this.items = itemArray;
        this.end = n2;
        this.start = n;
        this.index = n2 - 1;
    }

    public Item next() {
        if (this.index >= this.start) {
            this.current = this.items[this.index--];
            return this.current;
        }
        this.current = null;
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.end - 1 - this.index;
    }

    public int getLastPosition() {
        return this.end - this.start;
    }

    public SequenceIterator getAnother() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    public SequenceIterator getReverseIterator() {
        return new ArrayIterator(this.items, this.start, this.end);
    }
}

