/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualDocumentCopy;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;

public class VirtualCopy
implements NodeInfo {
    protected String baseURI;
    protected int documentNumber;
    protected NodeInfo original;
    protected VirtualCopy parent;
    protected NodeInfo root;

    protected VirtualCopy(NodeInfo nodeInfo) {
        this.original = nodeInfo;
    }

    public static VirtualCopy makeVirtualCopy(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        while (nodeInfo instanceof VirtualCopy) {
            nodeInfo = ((VirtualCopy)nodeInfo).original;
        }
        while (nodeInfo2 instanceof VirtualCopy) {
            nodeInfo2 = ((VirtualCopy)nodeInfo2).original;
        }
        VirtualCopy virtualCopy = nodeInfo instanceof DocumentInfo ? new VirtualDocumentCopy((DocumentInfo)nodeInfo) : new VirtualCopy(nodeInfo);
        virtualCopy.root = nodeInfo2;
        return virtualCopy;
    }

    public void setDocumentNumber(int n) {
        this.documentNumber = n;
    }

    public int getNodeKind() {
        return this.original.getNodeKind();
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return nodeInfo instanceof VirtualCopy && this.documentNumber == nodeInfo.getDocumentNumber() && this.original.isSameNodeInfo(((VirtualCopy)nodeInfo).original);
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return this.original.getLineNumber();
    }

    public int compareOrder(NodeInfo nodeInfo) {
        return this.original.compareOrder(((VirtualCopy)nodeInfo).original);
    }

    public String getStringValue() {
        return this.original.getStringValue();
    }

    public CharSequence getStringValueCS() {
        return this.original.getStringValueCS();
    }

    public int getNameCode() {
        return this.original.getNameCode();
    }

    public int getFingerprint() {
        return this.original.getFingerprint();
    }

    public String getLocalPart() {
        return this.original.getLocalPart();
    }

    public String getURI() {
        return this.original.getURI();
    }

    public String getPrefix() {
        return this.original.getPrefix();
    }

    public String getDisplayName() {
        return this.original.getDisplayName();
    }

    public Configuration getConfiguration() {
        return this.original.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.original.getNamePool();
    }

    public int getTypeAnnotation() {
        return this.original.getTypeAnnotation();
    }

    public NodeInfo getParent() {
        if (this.original.isSameNodeInfo(this.root)) {
            return null;
        }
        if (this.parent == null) {
            NodeInfo nodeInfo = this.original.getParent();
            if (nodeInfo == null) {
                return null;
            }
            this.parent = new VirtualCopy(nodeInfo);
            this.parent.setDocumentNumber(this.documentNumber);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        VirtualCopy virtualCopy = null;
        if (by == 3 || by == 2 || by == 8) {
            virtualCopy = this;
        } else if (by == 12 || by == 11 || by == 7) {
            virtualCopy = this.parent;
        }
        NodeInfo nodeInfo = Axis.isSubtreeAxis[by] ? null : this.root;
        return new VirtualCopier(this.original.iterateAxis(by, nodeTest), virtualCopy, nodeInfo);
    }

    public String getAttributeValue(int n) {
        return this.original.getAttributeValue(n);
    }

    public NodeInfo getRoot() {
        NodeInfo nodeInfo = this;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = nodeInfo.getParent()) != null) {
            nodeInfo = nodeInfo2;
        }
        return nodeInfo;
    }

    public DocumentInfo getDocumentRoot() {
        NodeInfo nodeInfo = this.getRoot();
        if (nodeInfo instanceof DocumentInfo) {
            return (DocumentInfo)nodeInfo;
        }
        return null;
    }

    public boolean hasChildNodes() {
        return this.original.hasChildNodes();
    }

    public String generateId() {
        return "d" + this.documentNumber + this.original.generateId();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        this.original.copy(receiver, n, bl, n2);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        this.original.sendNamespaceDeclarations(receiver, bl);
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return this.original.getDeclaredNamespaces(nArray);
    }

    public void setSystemId(String string) {
        this.baseURI = string;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.original.getTypedValue();
    }

    private class VirtualCopier
    implements AxisIterator,
    AtomizableIterator {
        private AxisIterator base;
        private VirtualCopy parent;
        private NodeInfo subtreeRoot;
        private Item current;

        public VirtualCopier(AxisIterator axisIterator, VirtualCopy virtualCopy2, NodeInfo nodeInfo) {
            this.base = axisIterator;
            this.parent = virtualCopy2;
            this.subtreeRoot = nodeInfo;
        }

        public void setIsAtomizing(boolean bl) {
            if (this.base instanceof AtomizableIterator) {
                ((AtomizableIterator)((Object)this.base)).setIsAtomizing(bl);
            }
        }

        public Item next() {
            Item item = this.base.next();
            if (item instanceof NodeInfo) {
                if (this.subtreeRoot != null && !this.isAncestorOrSelf(this.subtreeRoot, (NodeInfo)item)) {
                    return null;
                }
                VirtualCopy virtualCopy = VirtualCopy.makeVirtualCopy((NodeInfo)item, VirtualCopy.this.root);
                virtualCopy.parent = this.parent;
                virtualCopy.baseURI = VirtualCopy.this.baseURI;
                virtualCopy.documentNumber = VirtualCopy.this.documentNumber;
                item = virtualCopy;
            }
            this.current = item;
            return item;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() {
            return new VirtualCopier(this.base, this.parent, this.subtreeRoot);
        }

        private boolean isAncestorOrSelf(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
            do {
                if (!nodeInfo.isSameNodeInfo(nodeInfo2)) continue;
                return true;
            } while ((nodeInfo2 = nodeInfo2.getParent()) != null);
            return false;
        }
    }
}

