/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.Token;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;

public class CombinedNodeTest
extends NodeTest {
    private NodeTest nodetest1;
    private NodeTest nodetest2;
    private int operator;

    public CombinedNodeTest(NodeTest nodeTest, int n, NodeTest nodeTest2) {
        this.nodetest1 = nodeTest;
        this.operator = n;
        this.nodetest2 = nodeTest2;
    }

    public boolean matches(int n, int n2, int n3) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(n, n2, n3) || this.nodetest2.matches(n, n2, n3);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(n, n2, n3) || this.nodetest2 != null && !this.nodetest2.matches(n, n2, n3));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(n, n2, n3)) && this.nodetest2 != null && !this.nodetest2.matches(n, n2, n3);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(NodeInfo nodeInfo) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(nodeInfo) || this.nodetest2.matches(nodeInfo);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(nodeInfo) || this.nodetest2 != null && !this.nodetest2.matches(nodeInfo));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(nodeInfo)) && this.nodetest2 != null && !this.nodetest2.matches(nodeInfo);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public String toString(NamePool namePool) {
        String string;
        if (this.nodetest1 instanceof NameTest) {
            int n = this.nodetest1.getPrimitiveType();
            string = "";
            if (this.nodetest2 instanceof ContentTypeTest) {
                string = ", " + ((ContentTypeTest)this.nodetest2).getSchemaType().getDisplayName();
            }
            if (n == 1) {
                return "element(*" + string + ')';
            }
            if (n == 2) {
                return "attribute(*" + string + ')';
            }
        }
        String string2 = this.nodetest1 == null ? "true()" : this.nodetest1.toString(namePool);
        string = this.nodetest2 == null ? "true()" : this.nodetest2.toString(namePool);
        return '(' + string2 + ' ' + Token.tokens[this.operator] + ' ' + string + ')';
    }

    public ItemType getSuperType() {
        switch (this.operator) {
            case 1: {
                return Type.getCommonSuperType(this.nodetest1, this.nodetest2);
            }
            case 23: {
                return this.nodetest1;
            }
            case 24: {
                return this.nodetest1;
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public int getNodeKindMask() {
        switch (this.operator) {
            case 1: {
                return this.nodetest1.getNodeKindMask() | this.nodetest2.getNodeKindMask();
            }
            case 23: {
                return this.nodetest1.getNodeKindMask() & this.nodetest2.getNodeKindMask();
            }
            case 24: {
                return this.nodetest1.getNodeKindMask();
            }
        }
        return 0;
    }

    public int getPrimitiveType() {
        int n = this.getNodeKindMask();
        if (n == 2) {
            return 1;
        }
        if (n == 4) {
            return 2;
        }
        if (n == 512) {
            return 9;
        }
        return 0;
    }

    public Set getRequiredNodeNames() {
        Set set = this.nodetest1.getRequiredNodeNames();
        Set set2 = this.nodetest2.getRequiredNodeNames();
        if (set2 == null) {
            return set;
        }
        if (set == null) {
            return set2;
        }
        switch (this.operator) {
            case 1: {
                HashSet hashSet = new HashSet(set);
                hashSet.addAll(set2);
                return hashSet;
            }
            case 23: {
                HashSet hashSet = new HashSet(set);
                hashSet.retainAll(set2);
                return hashSet;
            }
            case 24: {
                HashSet hashSet = new HashSet(set);
                hashSet.removeAll(set2);
                return hashSet;
            }
        }
        throw new UnsupportedOperationException();
    }

    public SchemaType getContentType() {
        SchemaType schemaType;
        SchemaType schemaType2 = this.nodetest1.getContentType();
        if (schemaType2.isSameType(schemaType = this.nodetest2.getContentType())) {
            return schemaType2;
        }
        if (this.operator == 23) {
            if (schemaType instanceof AnyType) {
                return this.nodetest1.getContentType();
            }
            if (schemaType2 instanceof AnyType) {
                return this.nodetest2.getContentType();
            }
        }
        return AnyType.getInstance();
    }

    public int getFingerprint() {
        int n;
        int n2 = this.nodetest1.getFingerprint();
        if (n2 == (n = this.nodetest2.getFingerprint())) {
            return n2;
        }
        if (n == -1 && this.operator == 23) {
            return n2;
        }
        if (n2 == -1 && this.operator == 23) {
            return n;
        }
        return -1;
    }

    public int hashCode() {
        return this.nodetest1.hashCode() ^ this.nodetest2.hashCode();
    }

    public double getDefaultPriority() {
        return 0.25;
    }

    public NodeTest[] getComponentNodeTests() {
        NodeTest[] nodeTestArray = new NodeTest[]{this.nodetest1, this.nodetest2};
        return nodeTestArray;
    }
}

