/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UnresolvedReferenceException;

public class ContentTypeTest
extends NodeTest {
    private int kind;
    private SchemaType schemaType;
    private int requiredType;
    private Configuration config;

    public ContentTypeTest(int n, SchemaType schemaType, Configuration configuration) {
        this.kind = n;
        this.schemaType = schemaType;
        this.requiredType = schemaType.getFingerprint();
        this.config = configuration;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public ItemType getSuperType() {
        return NodeKindTest.makeNodeKindTest(this.kind);
    }

    public boolean matches(int n, int n2, int n3) {
        if (this.kind != n) {
            return false;
        }
        if (this.requiredType == -1 || this.requiredType == 572) {
            return true;
        }
        if (n3 == this.requiredType) {
            return true;
        }
        if (n3 == -1) {
            if (n == 1) {
                return this.requiredType == 641;
            }
            if (n == 2) {
                return this.requiredType == 642 || this.requiredType == 643 || this.requiredType == 573;
            }
            return false;
        }
        try {
            for (SchemaType schemaType = this.config.getSchemaType(n3 & 0xFFFFF).getBaseType(); schemaType != null; schemaType = schemaType.getBaseType()) {
                if (schemaType.getFingerprint() != this.requiredType) continue;
                return true;
            }
        }
        catch (UnresolvedReferenceException unresolvedReferenceException) {
            throw new IllegalStateException(unresolvedReferenceException.getMessage());
        }
        return false;
    }

    public boolean matches(NodeInfo nodeInfo) {
        return this.matches(nodeInfo.getNodeKind(), -1, nodeInfo.getTypeAnnotation());
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public SchemaType getContentType() {
        return this.schemaType;
    }

    public AtomicType getAtomizedItemType() {
        SimpleType simpleType;
        SchemaType schemaType = this.config.getSchemaType(this.requiredType);
        if (schemaType instanceof AtomicType) {
            return (AtomicType)schemaType;
        }
        if (schemaType instanceof ListType && (simpleType = ((ListType)schemaType).getItemType()) instanceof AtomicType) {
            return (AtomicType)simpleType;
        }
        return Type.ANY_ATOMIC_TYPE;
    }

    public String toString() {
        return (this.kind == 1 ? "element(*, " : "attribute(*, ") + this.schemaType.getDescription() + ')';
    }

    public int hashCode() {
        return this.kind << 20 ^ this.requiredType;
    }
}

