/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.ItemType;

public final class NamespaceTest
extends NodeTest {
    private NamePool namePool;
    private int nodeKind;
    private short uriCode;
    private String uri;

    public NamespaceTest(NamePool namePool, int n, String string) {
        this.namePool = namePool;
        this.nodeKind = n;
        this.uri = string;
        this.uriCode = namePool.allocateCodeForURI(string);
    }

    public boolean matches(int n, int n2, int n3) {
        if (n2 == -1) {
            return false;
        }
        if (n != this.nodeKind) {
            return false;
        }
        return this.uriCode == this.namePool.getURICode(n2);
    }

    public boolean matches(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.nodeKind && nodeInfo.getURI().equals(this.uri);
    }

    public final double getDefaultPriority() {
        return -0.25;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public ItemType getSuperType() {
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public String toString() {
        return '{' + this.namePool.getURIFromURICode(this.uriCode) + "}:*";
    }

    public int hashCode() {
        return this.uriCode << 5 + this.nodeKind;
    }
}

