/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullPushTee
extends PullFilter {
    private Receiver branch;
    boolean previousAtomic = false;

    public PullPushTee(PullProvider pullProvider, Receiver receiver) throws XPathException {
        super(pullProvider);
        this.branch = receiver;
        receiver.open();
    }

    public Receiver getReceiver() {
        return this.branch;
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.copyEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void copyEvent(int n) throws XPathException {
        PullProvider pullProvider = this.getUnderlyingProvider();
        Receiver receiver = this.branch;
        switch (n) {
            case 2: {
                receiver.startDocument(0);
                break;
            }
            case 4: {
                receiver.startElement(pullProvider.getNameCode(), pullProvider.getTypeAnnotation(), 0, 0);
                NamespaceDeclarations namespaceDeclarations = pullProvider.getNamespaceDeclarations();
                for (int i = 0; i < namespaceDeclarations.getLength(); ++i) {
                    receiver.namespace(namespaceDeclarations.getNamespaceCode(i), 0);
                }
                AttributeCollection attributeCollection = pullProvider.getAttributes();
                for (int i = 0; i < attributeCollection.getLength(); ++i) {
                    receiver.attribute(attributeCollection.getNameCode(i), attributeCollection.getTypeAnnotation(i), attributeCollection.getValue(i), 0, attributeCollection.getProperties(i));
                }
                receiver.startContent();
                break;
            }
            case 8: {
                receiver.characters(pullProvider.getStringValue(), 0, 0);
                break;
            }
            case 9: {
                receiver.comment(pullProvider.getStringValue(), 0, 0);
                break;
            }
            case 10: {
                receiver.processingInstruction(pullProvider.getPipelineConfiguration().getConfiguration().getNamePool().getLocalName(pullProvider.getNameCode()), pullProvider.getStringValue(), 0, 0);
                break;
            }
            case 5: {
                receiver.endElement();
                break;
            }
            case 3: {
                receiver.endDocument();
                break;
            }
            case -1: {
                pullProvider.close();
                receiver.close();
                break;
            }
            case 1: {
                if (receiver instanceof SequenceReceiver) {
                    ((SequenceReceiver)receiver).append(super.getAtomicValue(), 0, 0);
                    break;
                }
                if (this.previousAtomic) {
                    receiver.characters(" ", 0, 0);
                }
                CharSequence charSequence = pullProvider.getStringValue();
                receiver.characters(charSequence, 0, 0);
                break;
            }
            case 6: {
                if (receiver instanceof SequenceReceiver) {
                    Orphan orphan = new Orphan(pullProvider.getPipelineConfiguration().getConfiguration());
                    orphan.setNameCode(this.getNameCode());
                    orphan.setNodeKind((short)2);
                    orphan.setStringValue(this.getStringValue());
                    ((SequenceReceiver)receiver).append(orphan, 0, 0);
                    break;
                }
                receiver.attribute(this.getNameCode(), this.getTypeAnnotation(), this.getStringValue(), 0, 0);
                break;
            }
            case 7: {
                if (receiver instanceof SequenceReceiver) {
                    Orphan orphan = new Orphan(pullProvider.getPipelineConfiguration().getConfiguration());
                    orphan.setNameCode(this.getNameCode());
                    orphan.setNodeKind((short)13);
                    orphan.setStringValue(this.getStringValue());
                    ((SequenceReceiver)receiver).append(orphan, 0, 0);
                    break;
                }
                int n2 = this.getNamePool().getNamespaceCode(this.getNameCode());
                receiver.namespace(n2, 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("" + n);
            }
        }
        this.previousAtomic = n == 1;
    }
}

