/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullNamespaceReducer;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;

public class XQueryExpression
implements Container {
    private Expression expression;
    private SlotManager stackFrameMap;
    private Executable executable;
    private StaticQueryContext staticContext;
    private DocumentInstr documentInstruction;

    protected XQueryExpression(Expression expression, Executable executable, StaticQueryContext staticQueryContext, Configuration configuration) throws XPathException {
        this.stackFrameMap = staticQueryContext.getStackFrameMap();
        this.executable = executable;
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setParentExpression(this);
        }
        ExpressionTool.makeParentReferences(expression);
        try {
            expression = expression.simplify(staticQueryContext);
            expression = expression.analyze(staticQueryContext, Type.ITEM_TYPE);
        }
        catch (XPathException xPathException) {
            try {
                configuration.getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw xPathException;
        }
        ExpressionTool.allocateSlots(expression, 0, staticQueryContext.getStackFrameMap());
        this.expression = expression;
        this.executable.setConfiguration(configuration);
        this.executable.setDefaultCollationName(staticQueryContext.getDefaultCollationName());
        this.executable.setCollationTable(staticQueryContext.getAllCollations());
        this.staticContext = staticQueryContext;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public StaticQueryContext getStaticContext() {
        return this.staticContext;
    }

    protected void setDocumentInstruction(DocumentInstr documentInstr) {
        this.documentInstruction = documentInstr;
        documentInstr.setParentExpression(this);
    }

    public List evaluate(DynamicQueryContext dynamicQueryContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(Value.convert(item));
        }
        return arrayList;
    }

    public Object evaluateSingle(DynamicQueryContext dynamicQueryContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return Value.convert(item);
    }

    public SequenceIterator iterator(DynamicQueryContext dynamicQueryContext) throws XPathException {
        Controller controller = this.getController();
        this.initializeController(dynamicQueryContext, controller);
        try {
            SequenceIterator sequenceIterator;
            NodeInfo nodeInfo = dynamicQueryContext.getContextNode();
            Bindery bindery = controller.getBindery();
            controller.defineGlobalParameters(bindery);
            XPathContextMajor xPathContextMajor = controller.newXPathContext();
            if (controller.getConfiguration().getTraceListener() != null) {
                controller.preEvaluateGlobals(xPathContextMajor);
            }
            xPathContextMajor.openStackFrame(this.stackFrameMap);
            if (nodeInfo != null) {
                sequenceIterator = SingletonIterator.makeIterator(nodeInfo);
                sequenceIterator.next();
                xPathContextMajor.setCurrentIterator(sequenceIterator);
                controller.setPrincipalSourceDocument(nodeInfo.getDocumentRoot());
            }
            sequenceIterator = this.expression.iterate(xPathContextMajor);
            return new ErrorReportingIterator(sequenceIterator, controller.getErrorListener());
        }
        catch (XPathException xPathException) {
            TransformerException transformerException = xPathException;
            while (transformerException.getException() instanceof TransformerException) {
                transformerException = (TransformerException)transformerException.getException();
            }
            try {
                controller.getErrorListener().fatalError(transformerException);
            }
            catch (TransformerException transformerException2) {
                // empty catch block
            }
            throw DynamicError.makeDynamicError(transformerException);
        }
    }

    private void initializeController(DynamicQueryContext dynamicQueryContext, Controller controller) {
        HashMap hashMap = dynamicQueryContext.getParameters();
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = hashMap.get(string);
                controller.setParameter(string, v);
            }
        }
        controller.setURIResolver(dynamicQueryContext.getURIResolver());
        controller.setErrorListener(dynamicQueryContext.getErrorListener());
    }

    public void run(DynamicQueryContext dynamicQueryContext, Result result, Properties properties) throws XPathException {
        OutputStream outputStream;
        Object object;
        Object object2;
        Object object3;
        Controller controller = this.getController();
        this.initializeController(dynamicQueryContext, controller);
        Properties properties2 = controller.getOutputProperties();
        if (properties != null) {
            object3 = properties.propertyNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = properties.getProperty((String)object2);
                try {
                    SaxonOutputKeys.checkOutputProperty((String)object2, (String)object);
                    properties2.setProperty((String)object2, (String)object);
                }
                catch (DynamicError dynamicError) {
                    try {
                        controller.getErrorListener().fatalError(dynamicError);
                        throw dynamicError;
                    }
                    catch (TransformerException transformerException) {
                        throw DynamicError.makeDynamicError(transformerException);
                    }
                }
            }
        }
        object3 = dynamicQueryContext.getContextNode();
        object2 = controller.getBindery();
        controller.defineGlobalParameters((Bindery)object2);
        object = controller.newXPathContext();
        TraceListener traceListener = controller.getConfiguration().getTraceListener();
        if (traceListener != null) {
            controller.preEvaluateGlobals((XPathContext)object);
            traceListener.open();
        }
        ((XPathContextMajor)object).openStackFrame(this.stackFrameMap);
        if (object3 != null) {
            AxisIterator axisIterator = SingletonIterator.makeIterator((Item)object3);
            ((XPathContextMinor)object).setCurrentIterator(axisIterator);
            axisIterator.next();
            controller.setPrincipalSourceDocument(object3.getDocumentRoot());
        }
        boolean bl = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        ((XPathContextMinor)object).changeOutputDestination(properties2, result, true, 3, null);
        try {
            if (this.expression instanceof ElementCreator) {
                this.expression.process((XPathContext)object);
            } else {
                this.documentInstruction.process((XPathContext)object);
            }
        }
        catch (XPathException xPathException) {
            try {
                controller.getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw xPathException;
        }
        if (traceListener != null) {
            traceListener.close();
        }
        ((XPathContextMinor)object).getReceiver().close();
        if (bl && (outputStream = ((StreamResult)result).getOutputStream()) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new DynamicError(iOException);
            }
        }
    }

    public void pull(DynamicQueryContext dynamicQueryContext, Result result, Properties properties) throws XPathException {
        try {
            SequenceIterator sequenceIterator = this.iterator(dynamicQueryContext);
            PullProvider pullProvider = new PullFromIterator(sequenceIterator);
            pullProvider = new PullNamespaceReducer(pullProvider);
            pullProvider.setPipelineConfiguration(this.executable.getConfiguration().makePipelineConfiguration());
            Receiver receiver = ResultWrapper.getReceiver(result, pullProvider.getPipelineConfiguration(), properties);
            if ("yes".equals(properties.getProperty("{http://saxon.sf.net/}require-well-formed"))) {
                NamespaceReducer namespaceReducer = new NamespaceReducer();
                namespaceReducer.setPipelineConfiguration(pullProvider.getPipelineConfiguration());
                namespaceReducer.setUnderlyingReceiver(receiver);
                receiver = new SequenceWrapper(namespaceReducer);
            }
            new PullPushCopier(pullProvider, receiver).copy();
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw uncheckedXPathException.getXPathException();
        }
    }

    public Controller getController() {
        Controller controller = new Controller(this.executable.getConfiguration(), this.executable);
        this.executable.initialiseBindery(controller.getBindery());
        return controller;
    }

    public void explain(NamePool namePool) {
        System.err.println("============ Compiled Expression ============");
        this.expression.display(10, namePool, System.err);
        System.err.println("=============================================");
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public LocationProvider getLocationProvider() {
        return this.executable.getLocationMap();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    private class ErrorReportingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private ErrorListener listener;

        public ErrorReportingIterator(SequenceIterator sequenceIterator, ErrorListener errorListener) {
            this.base = sequenceIterator;
            this.listener = errorListener;
        }

        public Item next() throws XPathException {
            try {
                return this.base.next();
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(ExpressionTool.getLocator(XQueryExpression.this.expression));
                }
                try {
                    this.listener.fatalError(xPathException);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
                throw xPathException;
            }
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ErrorReportingIterator(this.base.getAnother(), this.listener);
        }
    }
}

