/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class SortKeyDefinition
implements Serializable {
    private static StringValue defaultOrder = new StringValue("ascending");
    private static StringValue defaultCaseOrder = new StringValue("#default");
    private static StringValue defaultLanguage = StringValue.EMPTY_STRING;
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = EmptySequence.getInstance();
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Expression collationName = null;
    protected Comparator collation;
    protected boolean emptyFirst = true;

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression expression) {
        this.dataTypeExpression = expression;
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationName(Expression expression) {
        this.collationName = expression;
    }

    public Expression getCollationName() {
        return this.collationName;
    }

    public void setCollation(Comparator comparator) {
        this.collation = comparator;
    }

    public Comparator getCollation() {
        return this.collation;
    }

    public void setEmptyFirst(boolean bl) {
        this.emptyFirst = bl;
    }

    public boolean getEmptyFirst() {
        return this.emptyFirst;
    }

    public SortKeyDefinition simplify(Executable executable) throws XPathException {
        if (this.order instanceof StringValue && (this.dataTypeExpression == null || this.dataTypeExpression instanceof StringValue) && this.caseOrder instanceof StringValue && this.language instanceof StringValue && this.collation != null) {
            FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
            fixedSortKeyDefinition.setSortKey(this.sortKey);
            fixedSortKeyDefinition.setOrder(this.order);
            fixedSortKeyDefinition.setDataTypeExpression(this.dataTypeExpression);
            fixedSortKeyDefinition.setCaseOrder(this.caseOrder);
            fixedSortKeyDefinition.setLanguage(this.language);
            fixedSortKeyDefinition.setEmptyFirst(this.emptyFirst);
            fixedSortKeyDefinition.collation = this.collation;
            fixedSortKeyDefinition.bindComparer(executable.getConfiguration());
            return fixedSortKeyDefinition;
        }
        return this;
    }

    public FixedSortKeyDefinition reduce(XPathContext xPathContext) throws XPathException {
        FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
        Expression expression = this.sortKey;
        fixedSortKeyDefinition.setSortKey(expression);
        fixedSortKeyDefinition.setOrder((StringValue)this.order.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setDataTypeExpression((StringValue)this.dataTypeExpression.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setCaseOrder((StringValue)this.caseOrder.evaluateItem(xPathContext));
        fixedSortKeyDefinition.setLanguage((StringValue)this.language.evaluateItem(xPathContext));
        if (this.collation == null && this.collationName != null) {
            String string = this.collationName.evaluateItem(xPathContext).getStringValue();
            Comparator comparator = xPathContext.getCollation(string);
            if (comparator == null) {
                throw new DynamicError("Collation " + string + " is not recognized");
            }
            fixedSortKeyDefinition.setCollation(comparator);
        }
        if (this.collation != null) {
            fixedSortKeyDefinition.setCollation(this.collation);
        }
        fixedSortKeyDefinition.setEmptyFirst(this.emptyFirst);
        fixedSortKeyDefinition.bindComparer(xPathContext);
        return fixedSortKeyDefinition;
    }
}

