/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SaxonEntityRef
extends StyleElement {
    String nameAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "name") {
                this.nameAttribute = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.nameAttribute == null) {
            this.reportAbsence("name");
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    public Expression compile(Executable executable) throws XPathException {
        ValueOf valueOf = new ValueOf(new StringValue('&' + this.nameAttribute + ';'), true);
        ExpressionTool.makeParentReferences(valueOf);
        return valueOf;
    }
}

