/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XSLAnalyzeString
extends StyleElement {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private StyleElement matching;
    private StyleElement nonMatching;
    private Pattern pattern;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws XPathException {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (n = 0; n < attributeCollection.getLength(); ++n) {
            int n2 = attributeCollection.getNameCode(n);
            String string4 = this.getNamePool().getClarkName(n2);
            if (string4 == "regex") {
                string2 = attributeCollection.getValue(n);
                continue;
            }
            if (string4 == "select") {
                string = attributeCollection.getValue(n);
                continue;
            }
            if (string4 == "flags") {
                string3 = attributeCollection.getValue(n).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string == null) {
            this.reportAbsence("select");
            string = ".";
        }
        this.select = this.makeExpression(string);
        if (string2 == null) {
            this.reportAbsence("regex");
            string2 = "xxx";
        }
        this.regex = this.makeAttributeValueTemplate(string2);
        if (string3 == null) {
            string3 = "";
        }
        this.flags = this.makeAttributeValueTemplate(string3);
        if (this.regex instanceof StringValue && this.flags instanceof StringValue) {
            n = 0;
            try {
                n = Matches.setFlags(((StringValue)this.flags).getStringValueCS());
            }
            catch (XPathException xPathException) {
                this.compileError("Invalid value of flags attribute: " + xPathException, "XTDE1145");
            }
            try {
                String string5 = RegexTranslator.translate(((StringValue)this.regex).getStringValueCS(), true);
                this.pattern = Pattern.compile(string5, n);
                if (this.pattern.matcher("").matches()) {
                    this.compileError("The regular expression must not be one that matches a zero-length string", "XTDE1150");
                }
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                this.compileError("Error in regular expression: " + regexSyntaxException, "XTDE1140");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.compileError("Error in regular expression: " + patternSyntaxException, "XTDE1140");
            }
        }
    }

    public void validate() throws XPathException {
        Object object;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = (NodeInfo)axisIterator.next()) != null) {
            if (object instanceof XSLFallback) continue;
            if (object instanceof XSLMatchingSubstring) {
                boolean bl = object.getLocalPart().equals("matching-substring");
                if (bl) {
                    if (this.matching != null) {
                        this.compileError("xsl:matching-substring element must only appear once", "XTSE0010");
                    }
                    this.matching = (StyleElement)object;
                    continue;
                }
                if (this.nonMatching != null) {
                    this.compileError("xsl:non-matching-substring element must only appear once", "XTSE0010");
                }
                this.nonMatching = (StyleElement)object;
                continue;
            }
            this.compileError("Only xsl:matching-substring and xsl:non-matching-substring are allowed here", "XTSE0010");
        }
        if (this.matching == null && this.nonMatching == null) {
            this.compileError("At least one xsl:matching-substring or xsl:non-matching-substring element must be present", "XTSE1130");
        }
        this.select = this.typeCheck("select", this.select);
        this.regex = this.typeCheck("regex", this.regex);
        this.flags = this.typeCheck("flags", this.flags);
        try {
            object = new RoleLocator(4, "xsl:analyze-string/select", 0, null);
            ExpressionLocation expressionLocation = new ExpressionLocation(this);
            ((RoleLocator)object).setSourceLocator(expressionLocation);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, (RoleLocator)object, this.getStaticContext());
            object = new RoleLocator(4, "xsl:analyze-string/regex", 0, null);
            ((RoleLocator)object).setSourceLocator(expressionLocation);
            this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, (RoleLocator)object, this.getStaticContext());
            object = new RoleLocator(4, "xsl:analyze-string/flags", 0, null);
            ((RoleLocator)object).setSourceLocator(expressionLocation);
            this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, (RoleLocator)object, this.getStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Expression expression = null;
        if (this.matching != null) {
            expression = this.matching.compileSequenceConstructor(executable, this.matching.iterateAxis((byte)3), false);
        }
        Expression expression2 = null;
        if (this.nonMatching != null) {
            expression2 = this.nonMatching.compileSequenceConstructor(executable, this.nonMatching.iterateAxis((byte)3), false);
        }
        try {
            AnalyzeString analyzeString = new AnalyzeString(this.select, this.regex, this.flags, expression == null ? null : expression.simplify(this.matching.getStaticContext()), expression2 == null ? null : expression2.simplify(this.nonMatching.getStaticContext()), this.pattern);
            ExpressionTool.makeParentReferences(analyzeString);
            return analyzeString;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

