/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class XSLDecimalFormat
extends StyleElement {
    boolean prepared = false;
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;

    public void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "name") {
                this.name = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string == "decimal-separator") {
                this.decimalSeparator = attributeCollection.getValue(i);
                continue;
            }
            if (string == "grouping-separator") {
                this.groupingSeparator = attributeCollection.getValue(i);
                continue;
            }
            if (string == "infinity") {
                this.infinity = attributeCollection.getValue(i);
                continue;
            }
            if (string == "minus-sign") {
                this.minusSign = attributeCollection.getValue(i);
                continue;
            }
            if (string == "NaN") {
                this.NaN = attributeCollection.getValue(i);
                continue;
            }
            if (string == "percent") {
                this.percent = attributeCollection.getValue(i);
                continue;
            }
            if (string == "per-mille") {
                this.perMille = attributeCollection.getValue(i);
                continue;
            }
            if (string == "zero-digit") {
                this.zeroDigit = attributeCollection.getValue(i);
                continue;
            }
            if (string == "digit") {
                this.digit = attributeCollection.getValue(i);
                continue;
            }
            if (string == "pattern-separator") {
                this.patternSeparator = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public DecimalFormatSymbols makeDecimalFormatSymbols() throws XPathException {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        if (this.decimalSeparator != null) {
            decimalFormatSymbols.setDecimalSeparator(this.toChar(this.decimalSeparator));
        }
        if (this.groupingSeparator != null) {
            decimalFormatSymbols.setGroupingSeparator(this.toChar(this.groupingSeparator));
        }
        if (this.infinity != null) {
            decimalFormatSymbols.setInfinity(this.infinity);
        }
        if (this.minusSign != null) {
            decimalFormatSymbols.setMinusSign(this.toChar(this.minusSign));
        }
        if (this.NaN != null) {
            decimalFormatSymbols.setNaN(this.NaN);
        }
        if (this.percent != null) {
            decimalFormatSymbols.setPercent(this.toChar(this.percent));
        }
        if (this.perMille != null) {
            decimalFormatSymbols.setPerMill(this.toChar(this.perMille));
        }
        if (this.zeroDigit != null) {
            decimalFormatSymbols.setZeroDigit(this.toChar(this.zeroDigit));
        }
        if (this.digit != null) {
            decimalFormatSymbols.setDigit(this.toChar(this.digit));
        }
        if (this.patternSeparator != null) {
            decimalFormatSymbols.setPatternSeparator(this.toChar(this.patternSeparator));
        }
        this.checkDistinctRoles(decimalFormatSymbols);
        return decimalFormatSymbols;
    }

    private void checkDistinctRoles(DecimalFormatSymbols decimalFormatSymbols) throws XPathException {
        HashMap<Character, String> hashMap = new HashMap<Character, String>(20);
        Character c = new Character(decimalFormatSymbols.getDecimalSeparator());
        hashMap.put(c, "decimal-separator");
        c = new Character(decimalFormatSymbols.getGroupingSeparator());
        if (hashMap.get(c) != null) {
            this.duplicate("grouping-separator", (String)hashMap.get(c));
        }
        hashMap.put(c, "grouping-separator");
        c = new Character(decimalFormatSymbols.getPercent());
        if (hashMap.get(c) != null) {
            this.duplicate("percent", (String)hashMap.get(c));
        }
        hashMap.put(c, "percent");
        c = new Character(decimalFormatSymbols.getPerMill());
        if (hashMap.get(c) != null) {
            this.duplicate("per-mille", (String)hashMap.get(c));
        }
        hashMap.put(c, "per-mille");
        c = new Character(decimalFormatSymbols.getZeroDigit());
        if (hashMap.get(c) != null) {
            this.duplicate("zero-digit", (String)hashMap.get(c));
        }
        hashMap.put(c, "zero-digit");
        c = new Character(decimalFormatSymbols.getDigit());
        if (hashMap.get(c) != null) {
            this.duplicate("digit", (String)hashMap.get(c));
        }
        hashMap.put(c, "digit");
        c = new Character(decimalFormatSymbols.getPatternSeparator());
        if (hashMap.get(c) != null) {
            this.duplicate("pattern-separator", (String)hashMap.get(c));
        }
        hashMap.put(c, "pattern-separator");
    }

    private void duplicate(String string, String string2) throws XPathException {
        this.compileError("The same character is used as the " + string + " and as the " + string2, "XTSE1300");
    }

    public void register() throws XPathException {
        this.prepareAttributes();
        DecimalFormatSymbols decimalFormatSymbols = this.makeDecimalFormatSymbols();
        DecimalFormatManager decimalFormatManager = this.getPrincipalStylesheet().getDecimalFormatManager();
        if (this.name == null) {
            try {
                decimalFormatManager.setDefaultDecimalFormat(decimalFormatSymbols, this.getPrecedence());
            }
            catch (StaticError staticError) {
                this.compileError(staticError.getMessage(), staticError.getErrorCodeLocalPart());
            }
        } else {
            try {
                this.makeNameCode(this.name);
                String[] stringArray = Name.getQNameParts(this.name);
                String string = this.getURIForPrefix(stringArray[0], false);
                try {
                    decimalFormatManager.setNamedDecimalFormat(string, stringArray[1], decimalFormatSymbols, this.getPrecedence());
                }
                catch (StaticError staticError) {
                    this.compileError(staticError.getMessage(), staticError.getErrorCodeLocalPart());
                }
            }
            catch (XPathException xPathException) {
                this.compileError("Invalid decimal format name. " + xPathException.getMessage(), "XTSE0020");
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid decimal format name. " + qNameException.getMessage(), "XTSE0020");
            }
            catch (NamespaceException namespaceException) {
                this.compileError("Invalid decimal format name. " + namespaceException.getMessage(), "XTSE0280");
            }
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }

    private char toChar(String string) throws XPathException {
        if (string.length() != 1) {
            this.compileError("Attribute \"" + string + "\" should be a single character", "XTSE0020");
        }
        return string.charAt(0);
    }
}

