/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentImpl includedDoc;

    public abstract boolean isImport();

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "href") {
                this.href = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    public XSLStylesheet getIncludedStylesheet(XSLStylesheet xSLStylesheet, int n) throws XPathException {
        if (this.href == null) {
            return null;
        }
        this.checkEmpty();
        this.checkTopLevel(this instanceof XSLInclude ? "XTSE0170" : "XTSE0190");
        try {
            Source source;
            XSLStylesheet xSLStylesheet2 = (XSLStylesheet)this.getParent();
            PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
            Configuration configuration = preparedStylesheet.getConfiguration();
            try {
                source = configuration.getURIResolver().resolve(this.href, this.getBaseURI());
            }
            catch (TransformerException transformerException) {
                throw StaticError.makeStaticError(transformerException);
            }
            if (source == null) {
                source = new StandardURIResolver(configuration).resolve(this.href, this.getBaseURI());
            }
            if (source.getSystemId() != null) {
                for (XSLStylesheet xSLStylesheet3 = xSLStylesheet2; xSLStylesheet3 != null; xSLStylesheet3 = xSLStylesheet3.getImporter()) {
                    if (!source.getSystemId().equals(xSLStylesheet3.getSystemId())) continue;
                    this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                    return null;
                }
            }
            StyleNodeFactory styleNodeFactory = new StyleNodeFactory(configuration);
            this.includedDoc = PreparedStylesheet.loadStylesheetModule(source, configuration, this.getNamePool(), styleNodeFactory);
            ElementImpl elementImpl = this.includedDoc.getDocumentElement();
            if (elementImpl instanceof LiteralResultElement) {
                this.includedDoc = ((LiteralResultElement)elementImpl).makeStylesheet(this.getPreparedStylesheet(), styleNodeFactory);
                elementImpl = this.includedDoc.getDocumentElement();
            }
            if (!(elementImpl instanceof XSLStylesheet)) {
                this.compileError("Included document " + this.href + " is not a stylesheet", "XTSE0165");
                return null;
            }
            XSLStylesheet xSLStylesheet4 = (XSLStylesheet)elementImpl;
            if (xSLStylesheet4.validationError != null) {
                if (this.reportingCircumstances == 1) {
                    xSLStylesheet4.compileError(xSLStylesheet4.validationError);
                } else if (xSLStylesheet4.reportingCircumstances == 2 && !xSLStylesheet4.forwardsCompatibleModeIsEnabled()) {
                    xSLStylesheet4.compileError(xSLStylesheet4.validationError);
                }
            }
            xSLStylesheet4.setPrecedence(n);
            xSLStylesheet4.setImporter(xSLStylesheet);
            xSLStylesheet4.spliceIncludes();
            xSLStylesheet2.setInputTypeAnnotations(xSLStylesheet4.getInputTypeAnnotationsAttribute() | xSLStylesheet4.getInputTypeAnnotations());
            return xSLStylesheet4;
        }
        catch (XPathException xPathException) {
            xPathException.setErrorCode("XTSE0165");
            this.compileError(xPathException);
            return null;
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }
}

