/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;

public class XSLOutput
extends StyleElement {
    private int fingerprint = -1;
    private String method = null;
    private String version = null;
    private String indent = null;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private String omitDeclaration = null;
    private String standalone = null;
    private String cdataElements = null;
    private String includeContentType = null;
    private String nextInChain = null;
    private String representation = null;
    private String indentSpaces = null;
    private String byteOrderMark = null;
    private String escapeURIAttributes = null;
    private String requireWellFormed = null;
    private String undeclareNamespaces = null;
    private String useCharacterMaps = null;
    private HashMap userAttributes = null;

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "method") {
                this.method = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "version") {
                this.version = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "byte-order-mark") {
                this.byteOrderMark = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "encoding") {
                this.encoding = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "omit-xml-declaration") {
                this.omitDeclaration = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "standalone") {
                this.standalone = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "doctype-public") {
                this.doctypePublic = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "doctype-system") {
                this.doctypeSystem = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "cdata-section-elements") {
                this.cdataElements = attributeCollection.getValue(i);
                continue;
            }
            if (string2 == "indent") {
                this.indent = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "media-type") {
                this.mediaType = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "include-content-type") {
                this.includeContentType = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "escape-uri-attributes") {
                this.escapeURIAttributes = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "use-character-maps") {
                this.useCharacterMaps = attributeCollection.getValue(i);
                continue;
            }
            if (string2 == "undeclare-prefixes") {
                this.undeclareNamespaces = attributeCollection.getValue(i);
                continue;
            }
            if (string2 == "{http://saxon.sf.net/}character-representation") {
                this.representation = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "{http://saxon.sf.net/}indent-spaces") {
                this.indentSpaces = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "{http://saxon.sf.net/}next-in-chain") {
                this.nextInChain = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "{http://saxon.sf.net/}require-well-formed") {
                this.requireWellFormed = attributeCollection.getValue(i).trim();
                continue;
            }
            String string3 = this.getNamePool().getURI(n);
            if ("".equals(string3) || "http://www.w3.org/1999/XSL/Transform".equals(string3) || "http://saxon.sf.net/".equals(string3)) {
                this.checkUnknownAttribute(n);
                continue;
            }
            String string4 = '{' + string3 + '}' + attributeCollection.getLocalName(i);
            if (this.userAttributes == null) {
                this.userAttributes = new HashMap(5);
            }
            this.userAttributes.put(string4, attributeCollection.getValue(i));
        }
        if (string != null) {
            try {
                this.fingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage(), "XTSE1570");
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XTSE1570");
            }
        }
    }

    public int getOutputFingerprint() {
        return this.fingerprint;
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public Expression compile(Executable executable) {
        return null;
    }

    protected void gatherOutputProperties(Properties properties) throws XPathException {
        Object object;
        String string;
        Object object2;
        if (this.method != null) {
            if (this.method.equals("xml") || this.method.equals("html") || this.method.equals("text") || this.method.equals("xhtml")) {
                properties.put("method", this.method);
            } else {
                try {
                    object2 = Name.getQNameParts(this.method);
                    string = object2[0];
                    if (string.equals("")) {
                        this.compileError("method must be xml, html, xhtml, or text, or a prefixed name", "XTSE1570");
                    } else {
                        object = this.getURIForPrefix(string, false);
                        if (object == null) {
                            this.undeclaredNamespaceError(string, "XTSE0280");
                        }
                        properties.put("method", '{' + (String)object + '}' + object2[1]);
                    }
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid method name. " + qNameException.getMessage(), "XTSE1570");
                }
            }
        }
        if (this.byteOrderMark != null) {
            if (this.byteOrderMark.equals("yes") || this.byteOrderMark.equals("no")) {
                properties.put("byte-order-mark", this.byteOrderMark);
            } else {
                this.compileError("byte-order-mark value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.version != null) {
            properties.put("version", this.version);
        }
        if (this.indent != null) {
            if (this.indent.equals("yes") || this.indent.equals("no")) {
                properties.put("indent", this.indent);
            } else {
                this.compileError("indent value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.indentSpaces != null) {
            try {
                Integer.parseInt(this.indentSpaces);
                properties.put("indent", "yes");
                properties.put("{http://saxon.sf.net/}indent-spaces", this.indentSpaces);
            }
            catch (NumberFormatException numberFormatException) {
                this.compileWarning("saxon:indent-spaces must be an integer. Using default value (3).", "SXWN9002");
            }
        }
        if (this.encoding != null) {
            properties.put("encoding", this.encoding);
        }
        if (this.mediaType != null) {
            properties.put("media-type", this.mediaType);
        }
        if (this.doctypeSystem != null) {
            properties.put("doctype-system", this.doctypeSystem);
        }
        if (this.doctypePublic != null) {
            properties.put("doctype-public", this.doctypePublic);
        }
        if (this.omitDeclaration != null) {
            if (this.omitDeclaration.equals("yes") || this.omitDeclaration.equals("no")) {
                properties.put("omit-xml-declaration", this.omitDeclaration);
            } else {
                this.compileError("omit-xml-declaration attribute must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.standalone != null) {
            if (this.standalone.equals("yes") || this.standalone.equals("no")) {
                properties.put("standalone", this.standalone);
            } else if (!this.standalone.equals("omit")) {
                this.compileError("standalone attribute must be 'yes' or 'no' or 'omit'", "XTSE0020");
            }
        }
        if (this.cdataElements != null) {
            object2 = properties.getProperty("cdata-section-elements");
            if (object2 == null) {
                object2 = "";
            }
            string = "";
            object = new StringTokenizer(this.cdataElements);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                try {
                    String[] stringArray = Name.getQNameParts(string2);
                    String string3 = this.getURIForPrefix(stringArray[0], true);
                    if (string3 == null) {
                        this.undeclaredNamespaceError(stringArray[0], "XTSE0280");
                    }
                    string = string + " {" + string3 + '}' + stringArray[1];
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid CDATA element name. " + qNameException.getMessage(), "XTSE0280");
                }
                properties.put("cdata-section-elements", (String)object2 + string);
            }
        }
        if (this.undeclareNamespaces != null) {
            if (this.undeclareNamespaces.equals("yes") || this.undeclareNamespaces.equals("no")) {
                properties.put("undeclare-prefixes", this.undeclareNamespaces);
            } else {
                this.compileError("undeclare-namespaces value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.useCharacterMaps != null) {
            object2 = XSLOutput.prepareCharacterMaps(this, this.useCharacterMaps, properties);
            properties.put("use-character-maps", object2);
        }
        if (this.representation != null) {
            properties.put("{http://saxon.sf.net/}character-representation", this.representation);
        }
        if (this.includeContentType != null) {
            if (this.includeContentType.equals("yes") || this.includeContentType.equals("no")) {
                properties.put("include-content-type", this.includeContentType);
            } else {
                this.compileError("include-content-type attribute must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.escapeURIAttributes != null) {
            if (this.escapeURIAttributes.equals("yes") || this.escapeURIAttributes.equals("no")) {
                properties.put("escape-uri-attibutes", this.escapeURIAttributes);
            } else {
                this.compileError("escape-uri-attributes value must be 'yes' or 'no'", "XTSE0020");
            }
        }
        if (this.nextInChain != null) {
            properties.put("{http://saxon.sf.net/}next-in-chain", this.nextInChain);
            properties.put("{http://saxon.sf.net/}next-in-chain-base-uri", this.getSystemId());
        }
        if (this.requireWellFormed != null) {
            if (this.requireWellFormed.equals("yes") || this.requireWellFormed.equals("no")) {
                properties.put("{http://saxon.sf.net/}require-well-formed", this.requireWellFormed);
            } else {
                this.compileWarning("saxon:require-well-formed value must be 'yes' or 'no' (treated as no)", "SXWN9003");
            }
        }
        if (this.userAttributes != null) {
            object2 = this.userAttributes.keySet().iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                object = (String)this.userAttributes.get(string);
                properties.put(string, object);
            }
        }
    }

    public static String prepareCharacterMaps(StyleElement styleElement, String string, Properties properties) throws XPathException {
        XSLStylesheet xSLStylesheet = styleElement.getPrincipalStylesheet();
        String string2 = properties.getProperty("use-character-maps");
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            try {
                int n;
                XSLCharacterMap xSLCharacterMap;
                String[] stringArray = Name.getQNameParts(string4);
                String string5 = styleElement.getURIForPrefix(stringArray[0], false);
                if (string5 == null) {
                    styleElement.undeclaredNamespaceError(stringArray[0], "XT0280");
                }
                if ((xSLCharacterMap = xSLStylesheet.getCharacterMap((n = styleElement.getTargetNamePool().allocate(stringArray[0], string5, stringArray[1])) & 0xFFFFF)) == null) {
                    styleElement.compileError("No character-map named '" + string4 + "' has been defined", "XTSE1590");
                }
                string3 = string3 + " {" + string5 + '}' + stringArray[1];
            }
            catch (QNameException qNameException) {
                styleElement.compileError("Invalid character-map name. " + qNameException.getMessage(), "XTSE1590");
            }
            string2 = string2 + string3;
        }
        return string2;
    }
}

