/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XSLParam
extends XSLVariableDeclaration {
    Expression conversion = null;

    protected boolean allowsValue() {
        return !(this.getParent() instanceof XSLFunction);
    }

    protected boolean allowsRequired() {
        return !(this.getParent() instanceof XSLFunction);
    }

    protected boolean allowsTunnelAttribute() {
        return true;
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo = this.getParent();
        boolean bl = nodeInfo instanceof XSLTemplate || nodeInfo instanceof XSLFunction;
        this.global = nodeInfo instanceof XSLStylesheet;
        if (!bl && !this.global) {
            this.compileError("xsl:param must be immediately within a template, function or stylesheet", "XTSE0010");
        }
        if (!this.global) {
            Object object;
            AxisIterator axisIterator = this.iterateAxis((byte)11);
            while ((object = (NodeInfo)axisIterator.next()) != null) {
                if (object instanceof XSLParam) {
                    if (this.getVariableFingerprint() != ((XSLParam)object).getVariableFingerprint()) continue;
                    this.compileError("The name of the parameter is not unique", "XTSE0580");
                    continue;
                }
                if (object instanceof StyleElement) {
                    this.compileError("xsl:param must be the first element within a template or function", "XTSE0010");
                    continue;
                }
                if (Navigator.isWhite(object.getStringValueCS())) continue;
                this.compileError("xsl:param must not be preceded by text", "XTSE0010");
            }
            object = this.getContainingSlotManager();
            if (object == null) {
                this.compileError("Local variable must be declared within a template or function", "XTSE0010");
            } else {
                this.setSlotNumber(((SlotManager)object).allocateSlotNumber(this.getVariableFingerprint()));
            }
        }
        if (this.requiredParam) {
            if (this.select != null) {
                this.compileError("The select attribute should be omitted when required='yes'", "XTSE0010");
            }
            if (this.hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
        }
        super.validate();
    }

    public Expression compile(Executable executable) throws XPathException {
        ComputedExpression computedExpression;
        if (this.getParent() instanceof XSLFunction) {
            return null;
        }
        int n = this.getSlotNumber();
        if (this.requiredType != null) {
            computedExpression = new SuppliedParameterReference(n);
            computedExpression.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
            RoleLocator roleLocator = new RoleLocator(3, this.getVariableName(), 0, null);
            roleLocator.setSourceLocator(new ExpressionLocation(this));
            this.conversion = TypeChecker.staticTypeCheck(computedExpression, this.requiredType, false, roleLocator, this.getStaticContext());
        }
        if (this.global) {
            computedExpression = new GlobalParam();
            ((GlobalParam)computedExpression).setExecutable(this.getExecutable());
            if (this.select instanceof ComputedExpression) {
                ((ComputedExpression)this.select).setParentExpression(computedExpression);
            }
        } else {
            computedExpression = new LocalParam();
            ((LocalParam)computedExpression).setConversion(this.conversion);
        }
        this.initializeInstruction(executable, (GeneralVariable)computedExpression);
        ((GeneralVariable)computedExpression).setVariableName(this.getVariableName());
        ((GeneralVariable)computedExpression).setSlotNumber(n);
        ((GeneralVariable)computedExpression).setRequiredType(this.getRequiredType());
        ExpressionTool.makeParentReferences(computedExpression);
        this.fixupBinding((Binding)((Object)computedExpression));
        return computedExpression;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType != null) {
            return this.requiredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

