/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XSLSort
extends StyleElement {
    private SortKeyDefinition sortKeyDefinition;
    private Expression select;
    private Expression order;
    private Expression dataType = null;
    private Expression caseOrder;
    private Expression lang;
    private Expression collationName;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string7 = this.getNamePool().getClarkName(n);
            if (string7 == "select") {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (string7 == "order") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string7 == "data-type") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string7 == "case-order") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string7 == "lang") {
                string5 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string7 == "collation") {
                string6 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        this.order = string2 == null ? new StringValue("ascending") : this.makeAttributeValueTemplate(string2);
        this.dataType = string3 == null ? EmptySequence.getInstance() : this.makeAttributeValueTemplate(string3);
        this.caseOrder = string4 == null ? new StringValue("#default") : this.makeAttributeValueTemplate(string4);
        this.lang = string5 == null ? new StringValue(Locale.getDefault().getLanguage()) : this.makeAttributeValueTemplate(string5);
        if (string6 != null) {
            this.collationName = this.makeAttributeValueTemplate(string6);
        }
    }

    public void validate() throws XPathException {
        Object object;
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An xsl:sort element with a select attribute must be empty");
        }
        if (this.select == null && !this.hasChildNodes()) {
            this.select = new ContextItemExpression();
        }
        Comparator comparator = null;
        if (this.collationName instanceof StringValue) {
            object = ((StringValue)this.collationName).getStringValue();
            comparator = this.getPrincipalStylesheet().findCollation((String)object);
            if (comparator == null) {
                this.compileError("Collation " + (String)object + " has not been defined");
                comparator = Collator.getInstance();
            }
        }
        this.select = this.typeCheck("select", this.select);
        this.order = this.typeCheck("order", this.order);
        this.caseOrder = this.typeCheck("case-order", this.caseOrder);
        this.lang = this.typeCheck("lang", this.lang);
        this.dataType = this.typeCheck("data-type", this.dataType);
        this.collationName = this.typeCheck("collation", this.collationName);
        if (this.select != null) {
            try {
                object = new RoleLocator(4, "xsl:sort/select", 0, null);
                ((RoleLocator)object).setSourceLocator(new ExpressionLocation(this));
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.ATOMIC_SEQUENCE, false, (RoleLocator)object, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.sortKeyDefinition = new SortKeyDefinition();
        this.sortKeyDefinition.setOrder(this.order);
        this.sortKeyDefinition.setCaseOrder(this.caseOrder);
        this.sortKeyDefinition.setLanguage(this.lang);
        this.sortKeyDefinition.setSortKey(this.select);
        this.sortKeyDefinition.setDataTypeExpression(this.dataType);
        this.sortKeyDefinition.setCollationName(this.collationName);
        this.sortKeyDefinition.setCollation(comparator);
    }

    protected ItemType getReturnedItemType() {
        return null;
    }

    public Expression compile(Executable executable) throws XPathException {
        if (this.select == null) {
            Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
            if (expression == null) {
                expression = EmptySequence.getInstance();
            }
            try {
                StaticContext staticContext = this.getStaticContext();
                this.sortKeyDefinition.setSortKey(new Atomizer(expression.simplify(staticContext), staticContext.getConfiguration()));
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.sortKeyDefinition = this.sortKeyDefinition.simplify(executable);
        return null;
    }

    public SortKeyDefinition getSortKeyDefinition() {
        return this.sortKeyDefinition;
    }
}

