/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocalVariable;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class XSLVariable
extends XSLVariableDeclaration {
    private int state = 0;

    public void prepareAttributes() throws XPathException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable", "XTDE0640");
        }
        this.state = 1;
        super.prepareAttributes();
        this.state = 2;
    }

    public boolean isInstruction() {
        return true;
    }

    public SequenceType getRequiredType() {
        SequenceType sequenceType;
        SequenceType sequenceType2 = sequenceType = this.requiredType == null ? SequenceType.ANY_SEQUENCE : this.requiredType;
        if (this.assignable) {
            return sequenceType;
        }
        if (this.requiredType != null) {
            return this.requiredType;
        }
        if (this.select != null) {
            if (this.select instanceof EmptySequence) {
                return sequenceType;
            }
            try {
                return SequenceType.makeSequenceType(this.select.getItemType(), this.select.getCardinality());
            }
            catch (Exception exception) {
                return sequenceType;
            }
        }
        if (this.hasChildNodes()) {
            return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
        }
        return SequenceType.SINGLE_STRING;
    }

    public Expression compile(Executable executable) throws XPathException {
        if (this.references.size() == 0 && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            if (this.global) {
                GlobalVariable globalVariable = new GlobalVariable();
                globalVariable.setExecutable(this.getExecutable());
                if (this.select instanceof ComputedExpression) {
                    ((ComputedExpression)this.select).setParentExpression(globalVariable);
                }
                this.initializeInstruction(executable, globalVariable);
                globalVariable.setVariableName(this.getVariableName());
                globalVariable.setSlotNumber(this.getSlotNumber());
                globalVariable.setRequiredType(this.getRequiredType());
                ExpressionTool.makeParentReferences(globalVariable);
                this.fixupBinding(globalVariable);
                return globalVariable;
            }
            LocalVariable localVariable = new LocalVariable();
            if (this.select instanceof ComputedExpression) {
                ((ComputedExpression)this.select).setParentExpression(localVariable);
            }
            this.initializeInstruction(executable, localVariable);
            localVariable.setVariableName(this.getVariableName());
            localVariable.setSlotNumber(this.getSlotNumber());
            localVariable.setRequiredType(this.getRequiredType());
            ExpressionTool.makeParentReferences(localVariable);
            this.fixupBinding(localVariable);
            return localVariable;
        }
        return null;
    }

    public Expression newCompile(Executable executable) throws XPathException {
        if (this.references.size() == 0 && !this.assignable) {
            this.redundant = true;
        }
        if (!this.redundant) {
            if (this.global) {
                GlobalVariable globalVariable = new GlobalVariable();
                globalVariable.setExecutable(this.getExecutable());
                if (this.select instanceof ComputedExpression) {
                    ((ComputedExpression)this.select).setParentExpression(globalVariable);
                }
                this.initializeInstruction(executable, globalVariable);
                globalVariable.setVariableName(this.getVariableName());
                globalVariable.setSlotNumber(this.getSlotNumber());
                globalVariable.setRequiredType(this.getRequiredType());
                ExpressionTool.makeParentReferences(globalVariable);
                this.fixupBinding(globalVariable);
                return globalVariable;
            }
            LocalVariable localVariable = new LocalVariable();
            if (this.select instanceof ComputedExpression) {
                ((ComputedExpression)this.select).setParentExpression(localVariable);
            }
            this.initializeInstruction(executable, localVariable);
            localVariable.setVariableName(this.getVariableName());
            localVariable.setRequiredType(this.getRequiredType());
            ExpressionTool.makeParentReferences(localVariable);
            return localVariable;
        }
        return null;
    }
}

