/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;

final class FollowingEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private NodeTest test;
    private boolean includeDescendants;

    public FollowingEnumeration(TinyTree tinyTree, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.tree = tinyTree;
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.includeDescendants = bl;
    }

    public Item next() {
        int n;
        if (this.position == 0) {
            n = this.startNode.nodeNr;
            short s = this.tree.depth[n];
            if (this.includeDescendants) {
                ++n;
            } else {
                do {
                    if (this.tree.depth[++n] != 0) continue;
                    this.current = null;
                    this.position = -1;
                    return null;
                } while (this.tree.depth[n] > s);
            }
        } else {
            n = ((TinyNodeImpl)this.current).nodeNr + 1;
        }
        while (true) {
            if (this.tree.depth[n] == 0) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (this.test.matches(this.tree.nodeKind[n], this.tree.nameCode[n], this.tree.getElementAnnotation(n))) {
                ++this.position;
                this.current = this.tree.getNode(n);
                return this.current;
            }
            ++n;
        }
    }

    public SequenceIterator getAnother() {
        return new FollowingEnumeration(this.tree, this.startNode, this.test, this.includeDescendants);
    }
}

