/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.functions.FormatNumber2;
import net.sf.saxon.trans.StaticError;

public class DecimalFormatManager
implements Serializable {
    private DecimalFormatSymbols defaultDFS;
    private HashMap formatTable = new HashMap(10);
    private boolean usingOriginalDefault = true;

    public DecimalFormatManager() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        this.defaultDFS = decimalFormatSymbols;
    }

    public static void setDefaults(DecimalFormatSymbols decimalFormatSymbols) {
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setInfinity("Infinity");
        decimalFormatSymbols.setMinusSign('-');
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setPerMill('\u2030');
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setPatternSeparator(';');
    }

    public void setDefaultDecimalFormat(DecimalFormatSymbols decimalFormatSymbols, int n) throws StaticError {
        if (!this.usingOriginalDefault && !decimalFormatSymbols.equals(this.defaultDFS)) {
            StaticError staticError = new StaticError("There are two conflicting definitions of the default decimal format");
            staticError.setErrorCode("XTSE1290");
            throw staticError;
        }
        this.defaultDFS = decimalFormatSymbols;
        this.usingOriginalDefault = false;
        this.setNamedDecimalFormat("", "", decimalFormatSymbols, n);
    }

    public void fixupDefaultDefault() throws StaticError {
        if (this.usingOriginalDefault) {
            this.setNamedDecimalFormat("", "", this.defaultDFS, -1000);
        }
    }

    public DecimalFormatSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(String string, String string2, DecimalFormatSymbols decimalFormatSymbols, int n) throws StaticError {
        Object object;
        String string3 = string2 + '#' + string;
        Object v = this.formatTable.get(string3);
        if (v != null) {
            if (v instanceof List) {
                object = ((List)v).iterator();
                while (object.hasNext()) {
                    FormatNumber2 formatNumber2 = (FormatNumber2)object.next();
                    formatNumber2.fixup(decimalFormatSymbols);
                }
            } else {
                object = (DecimalFormatInfo)v;
                DecimalFormatSymbols decimalFormatSymbols2 = ((DecimalFormatInfo)object).dfs;
                int n2 = ((DecimalFormatInfo)object).precedence;
                if (n < n2) {
                    return;
                }
                if (n == n2 && !decimalFormatSymbols.equals(decimalFormatSymbols2)) {
                    StaticError staticError = new StaticError("There are two conflicting definitions of the named decimal-format");
                    staticError.setErrorCode("XTSE1290");
                    throw staticError;
                }
            }
        }
        object = new DecimalFormatInfo();
        ((DecimalFormatInfo)object).dfs = decimalFormatSymbols;
        ((DecimalFormatInfo)object).precedence = n;
        this.formatTable.put(string3, object);
    }

    public void registerUsage(String string, String string2, FormatNumber2 formatNumber2) {
        String string3 = string2 + '#' + string;
        Object v = this.formatTable.get(string3);
        if (v == null) {
            ArrayList<FormatNumber2> arrayList = new ArrayList<FormatNumber2>(10);
            arrayList.add(formatNumber2);
            this.formatTable.put(string3, arrayList);
        } else if (v instanceof List) {
            List list = (List)v;
            list.add(formatNumber2);
        } else {
            DecimalFormatInfo decimalFormatInfo = (DecimalFormatInfo)v;
            formatNumber2.fixup(decimalFormatInfo.dfs);
        }
    }

    public DecimalFormatSymbols getNamedDecimalFormat(String string, String string2) {
        String string3 = string2 + '#' + string;
        DecimalFormatInfo decimalFormatInfo = (DecimalFormatInfo)this.formatTable.get(string3);
        if (decimalFormatInfo == null) {
            return null;
        }
        return decimalFormatInfo.dfs;
    }

    private static class DecimalFormatInfo
    implements Serializable {
        public DecimalFormatSymbols dfs;
        public int precedence;

        private DecimalFormatInfo() {
        }
    }
}

