/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;

public class ElementWithAttributes
extends ElementImpl {
    protected AttributeCollection attributeList;
    protected int[] namespaceList = null;

    public void initialise(int n, AttributeCollectionImpl attributeCollectionImpl, NodeInfo nodeInfo, String string, int n2, int n3) {
        this.nameCode = n;
        this.attributeList = attributeCollectionImpl;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n3;
        this.root = (DocumentImpl)nodeInfo.getDocumentRoot();
        this.root.setLineNumber(n3, n2);
        this.root.setSystemId(n3, string);
    }

    public void setNamespaceDeclarations(int[] nArray, int n) {
        this.namespaceList = new int[n];
        System.arraycopy(nArray, 0, this.namespaceList, 0, n);
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("") && !bl) {
            return "";
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForPrefix(string);
        if (s == -1) {
            return null;
        }
        try {
            short s2 = this.getURICodeForPrefixCode(s);
            return namePool.getURIFromURICode(s2);
        }
        catch (NamespaceException namespaceException) {
            return null;
        }
    }

    public Iterator iteratePrefixes() {
        HashSet<String> hashSet = new HashSet<String>(10);
        HashSet hashSet2 = new HashSet(10);
        hashSet.add("");
        hashSet.add("xml");
        this.gatherNamespacePrefixes(this.getNamePool(), hashSet, hashSet2);
        return hashSet.iterator();
    }

    public short getURICodeForPrefix(String string) throws NamespaceException {
        if (string.equals("xml")) {
            return 1;
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForPrefix(string);
        if (s == -1) {
            throw new NamespaceException(string);
        }
        return this.getURICodeForPrefixCode(s);
    }

    private short getURICodeForPrefixCode(int n) throws NamespaceException {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if (this.namespaceList[i] >> 16 != n) continue;
                return (short)(this.namespaceList[i] & 0xFFFF);
            }
        }
        NodeInfo nodeInfo = this.parent;
        while (true) {
            if (nodeInfo.getNodeKind() == 9) {
                if (n == 0) {
                    return 0;
                }
                throw new NamespaceException(this.getNamePool().getPrefixFromNamespaceCode(n << 16));
            }
            if (nodeInfo instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeInfo).getURICodeForPrefixCode(n);
            }
            nodeInfo = nodeInfo.getParent();
        }
    }

    public String getPrefixForURI(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        NamePool namePool = this.getNamePool();
        short s = namePool.getCodeForURI(string);
        if (s < 0) {
            return null;
        }
        return this.getPrefixForURICode(s);
    }

    private String getPrefixForURICode(int n) {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if ((this.namespaceList[i] & 0xFFFF) != n) continue;
                return this.getNamePool().getPrefixFromNamespaceCode(this.namespaceList[i]);
            }
        }
        NodeInfo nodeInfo = this.parent;
        while (!(nodeInfo instanceof DocumentInfo)) {
            if (nodeInfo instanceof ElementWithAttributes) {
                return ((ElementWithAttributes)nodeInfo).getPrefixForURICode(n);
            }
            nodeInfo = nodeInfo.getParent();
        }
        return null;
    }

    private void gatherNamespacePrefixes(NamePool namePool, Set set, Set set2) {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                int n = this.namespaceList[i];
                String string = namePool.getPrefixFromNamespaceCode(n);
                if ((n & 0xFFFF) == 0) {
                    set2.add(string);
                    continue;
                }
                if (set2.contains(string)) continue;
                set.add(string);
                set2.add(string);
            }
        }
        NodeInfo nodeInfo = this.getParent();
        while (nodeInfo != null) {
            if (!(nodeInfo instanceof ElementWithAttributes)) continue;
            ((ElementWithAttributes)nodeInfo).gatherNamespacePrefixes(namePool, set, set2);
        }
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                receiver.namespace(this.namespaceList[i], 0);
            }
        }
        if (bl && this.parent.getNodeKind() != 9) {
            this.parent.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return this.namespaceList;
    }

    public int[] getInScopeNamespaceCodes() {
        return new NamespaceIterator(this, null).getInScopeNamespaceCodes();
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList;
    }

    public String getAttributeValue(int n) {
        return this.attributeList.getValueByFingerprint(n);
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        int n3;
        int n4;
        int n5 = n4 = bl ? this.getTypeAnnotation() : -1;
        if (n2 == 0 && receiver instanceof LocationCopier) {
            receiver.setSystemId(this.getSystemId());
            ((LocationCopier)receiver).setLineNumber(this.getLineNumber());
        }
        receiver.startElement(this.getNameCode(), n4, n2, 0);
        if (n != 0) {
            this.sendNamespaceDeclarations(receiver, n == 2);
        }
        for (n3 = 0; n3 < this.attributeList.getLength(); ++n3) {
            receiver.attribute(this.attributeList.getNameCode(n3), -1, this.attributeList.getValue(n3), 0, 0);
        }
        receiver.startContent();
        n3 = n == 0 ? 0 : 1;
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            nodeImpl.copy(receiver, n3, bl, n2);
        }
        receiver.endElement();
    }
}

