/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.SecondsDurationValue;

public abstract class CalendarValue
extends AtomicValue
implements Comparable {
    protected GregorianCalendar calendar;
    protected boolean zoneSpecified;

    public abstract CalendarValue add(DurationValue var1) throws XPathException;

    public SecondsDurationValue subtract(CalendarValue calendarValue, ConversionContext conversionContext) throws XPathException {
        CalendarValue calendarValue2 = this;
        CalendarValue calendarValue3 = calendarValue;
        if (calendarValue2.zoneSpecified != calendarValue3.zoneSpecified) {
            SecondsDurationValue secondsDurationValue = SecondsDurationValue.fromMilliseconds(conversionContext.getImplicitTimezone() * 60000);
            if (!calendarValue2.zoneSpecified) {
                calendarValue2 = calendarValue2.setTimezone(secondsDurationValue);
            }
            if (!calendarValue3.zoneSpecified) {
                calendarValue3 = calendarValue3.setTimezone(secondsDurationValue);
            }
        }
        long l = calendarValue2.calendar.getTimeInMillis();
        long l2 = calendarValue3.calendar.getTimeInMillis();
        long l3 = l - l2;
        return SecondsDurationValue.fromMilliseconds(l3);
    }

    public abstract CalendarValue removeTimezone() throws XPathException;

    public abstract CalendarValue setTimezone(SecondsDurationValue var1) throws XPathException;

    public abstract int compareTo(CalendarValue var1, ConversionContext var2);
}

