/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class Closure
extends Value {
    protected Expression expression;
    protected XPathContextMajor savedXPathContext;
    protected int depth = 0;
    protected SequenceIterator inputIterator;

    protected Closure() {
    }

    public static Value make(Expression expression, XPathContext xPathContext, boolean bl) throws XPathException {
        ValueRepresentation[] valueRepresentationArray;
        Object object;
        Expression expression2;
        Object object2;
        if (expression instanceof ErrorExpression) {
            expression.evaluateItem(xPathContext);
            return null;
        }
        if (expression instanceof TailExpression && (object2 = ((TailExpression)(expression2 = (TailExpression)expression)).getBaseExpression()) instanceof VariableReference) {
            if ((object2 = Value.asValue(ExpressionTool.lazyEvaluate((Expression)object2, xPathContext, bl))) instanceof MemoClosure) {
                object = object2.iterate(null);
                object2 = ((GroundedIterator)object).materialize();
            }
            if (object2 instanceof IntegerRange) {
                long l;
                long l2 = ((IntegerRange)object2).getStart() + 1L;
                if (l2 == (l = ((IntegerRange)object2).getEnd())) {
                    return new IntegerValue(l);
                }
                return new IntegerRange(l2, l);
            }
            if (object2 instanceof SequenceExtent) {
                return new SequenceExtent((SequenceExtent)object2, ((TailExpression)expression2).getStart() - 1, ((SequenceExtent)object2).getLength() - ((TailExpression)expression2).getStart() + 1);
            }
        }
        expression2 = bl ? new MemoClosure() : new Closure();
        ((Closure)expression2).expression = expression;
        ((Closure)expression2).savedXPathContext = xPathContext.newContext();
        ((Closure)expression2).savedXPathContext.setOriginatingConstructType(2063);
        if ((expression.getDependencies() & 0x80) != 0 && (object = ((StackFrame)(object2 = xPathContext.getStackFrame())).getStackFrameValues()) != null) {
            valueRepresentationArray = new ValueRepresentation[((ValueRepresentation[])object).length];
            for (int i = 0; i < ((ValueRepresentation[])object).length; ++i) {
                if (object[i] instanceof Closure) {
                    int n = ((Closure)object[i]).depth;
                    if (n >= 10) {
                        object[i] = ExpressionTool.eagerEvaluate((Closure)object[i], xPathContext);
                    } else if (n + 1 > ((Closure)expression2).depth) {
                        ((Closure)expression2).depth = n + 1;
                    }
                }
                valueRepresentationArray[i] = object[i];
            }
            ((Closure)expression2).savedXPathContext.setStackFrame(((StackFrame)object2).getStackFrameMap(), valueRepresentationArray);
        }
        if ((object2 = xPathContext.getCurrentIterator()) != null) {
            object = object2.current();
            valueRepresentationArray = SingletonIterator.makeIterator((Item)object);
            valueRepresentationArray.next();
            ((Closure)expression2).savedXPathContext.setCurrentIterator((SequenceIterator)valueRepresentationArray);
        }
        ((Closure)expression2).savedXPathContext.setReceiver(new SequenceOutputter());
        return expression2;
    }

    public ItemType getItemType() {
        return this.expression.getItemType();
    }

    public int getCardinality() {
        return this.expression.getCardinality();
    }

    public int getSpecialProperties() {
        return this.expression.getSpecialProperties();
    }

    public int getImplementationMethod() {
        return 6;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.inputIterator == null) {
            this.inputIterator = this.expression.iterate(this.savedXPathContext);
            return this.inputIterator;
        }
        return this.inputIterator.getAnother();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        XPathContextMajor xPathContextMajor = this.savedXPathContext.newContext();
        xPathContextMajor.setTemporaryReceiver(xPathContext.getReceiver());
        this.expression.process(xPathContextMajor);
    }

    public Value reduce() throws XPathException {
        return new SequenceExtent(this.iterate(null)).reduce();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "Closure of expression:");
        this.expression.display(n + 1, namePool, printStream);
    }
}

