/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class DateValue
extends CalendarValue {
    protected int tzOffset = 0;
    private Date UTCDate = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    protected DateValue() {
    }

    public DateValue(CharSequence charSequence) throws XPathException {
        this.setLexicalValue(charSequence);
    }

    public DateValue(GregorianCalendar gregorianCalendar, boolean bl, int n) {
        this.calendar = gregorianCalendar;
        this.zoneSpecified = bl;
        this.tzOffset = n;
    }

    public void setLexicalValue(CharSequence charSequence) throws XPathException {
        this.zoneSpecified = false;
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)DateValue.trimWhitespace(charSequence)).toString(), "-:+Z", true);
        try {
            Object object;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if ("+".equals(string)) {
                string = (String)stringTokenizer.nextElement();
            } else if ("-".equals(string)) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            int n2 = Integer.parseInt(string) * n;
            if (string.length() < 4) {
                this.badDate("Year is less than four digits", charSequence);
            }
            if (n2 == 0) {
                this.badDate("Year zero is not allowed", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after year", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Month must be two digits", charSequence);
            }
            if (n3 < 1 || n3 > 12) {
                this.badDate("Month is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after month", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            string = (String)stringTokenizer.nextElement();
            int n4 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Day must be two digits", charSequence);
            }
            if (n4 < 1 || n4 > 31) {
                this.badDate("Day is out of range", charSequence);
            }
            if (stringTokenizer.hasMoreElements()) {
                object = (String)stringTokenizer.nextElement();
                if ("Z".equals(object)) {
                    this.zoneSpecified = true;
                    this.tzOffset = 0;
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after 'Z'", charSequence);
                    }
                } else if ("+".equals(object) || "-".equals(object)) {
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("Missing timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n5 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone hour must be two digits", charSequence);
                    }
                    if (n5 > 14) {
                        this.badDate("Timezone hour is out of range", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    if (!":".equals(stringTokenizer.nextElement())) {
                        this.badDate("Wrong delimiter after timezone hour", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n6 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone minute must be two digits", charSequence);
                    }
                    if (n6 > 59) {
                        this.badDate("Timezone minute is out of range", charSequence);
                    }
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after timezone", charSequence);
                    }
                    this.tzOffset = n5 * 60 + n6;
                    if ("-".equals(object)) {
                        this.tzOffset = -this.tzOffset;
                    }
                } else {
                    this.badDate("Timezone format is incorrect", charSequence);
                }
            }
            object = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
            this.calendar = new GregorianCalendar((TimeZone)object);
            this.calendar.clear();
            this.calendar.setLenient(false);
            this.calendar.set(Math.abs(n2), n3 - 1, n4);
            this.calendar.set(15, this.tzOffset * 60000);
            this.calendar.set(16, 0);
            if (n2 < 0) {
                this.calendar.set(0, 0);
            }
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badDate("Non-existent date", charSequence);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("Non-numeric component", charSequence);
        }
    }

    private void badDate(String string, CharSequence charSequence) throws ValidationException {
        ValidationException validationException = new ValidationException("Invalid date " + Err.wrap(charSequence, 4) + ". " + string);
        validationException.setErrorCode("FORG0001");
        throw validationException;
    }

    public Date getUTCDate() {
        if (this.UTCDate == null) {
            this.UTCDate = this.calendar.getTime();
        }
        return this.UTCDate;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 521: 
            case 643: {
                return this;
            }
            case 519: {
                return new DateTimeValue(this.calendar, this.zoneSpecified);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 523: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(this.calendar.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(this.calendar.get(1), 0, 1);
                gregorianCalendar.set(15, this.tzOffset * 60000);
                gregorianCalendar.set(16, 0);
                this.calendar.getTime();
                return new GYearValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
            }
            case 522: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(this.calendar.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(this.calendar.get(1), this.calendar.get(2), 1);
                gregorianCalendar.set(15, this.tzOffset * 60000);
                gregorianCalendar.set(16, 0);
                this.calendar.getTime();
                return new GYearMonthValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
            }
            case 526: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(this.calendar.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(2000, this.calendar.get(2), 1);
                gregorianCalendar.set(15, this.tzOffset * 60000);
                gregorianCalendar.set(16, 0);
                this.calendar.getTime();
                return new GMonthValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
            }
            case 524: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(this.calendar.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(2000, this.calendar.get(2), this.calendar.get(5));
                gregorianCalendar.set(15, this.tzOffset * 60000);
                gregorianCalendar.set(16, 0);
                this.calendar.getTime();
                return new GMonthDayValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
            }
            case 525: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(this.calendar.getTimeZone());
                gregorianCalendar.clear();
                gregorianCalendar.set(2000, 0, this.calendar.get(5));
                gregorianCalendar.set(15, this.tzOffset * 60000);
                gregorianCalendar.set(16, 0);
                this.calendar.getTime();
                return new GDayValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert date to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n = this.calendar.get(0);
        int n2 = this.calendar.get(1);
        if (n == 0) {
            fastStringBuffer.append('-');
        }
        DateTimeValue.appendString(fastStringBuffer, n2, n2 > 9999 ? (this.calendar.get(1) + "").length() : 4);
        fastStringBuffer.append('-');
        DateTimeValue.appendString(fastStringBuffer, this.calendar.get(2) + 1, 2);
        fastStringBuffer.append('-');
        DateTimeValue.appendString(fastStringBuffer, this.calendar.get(5), 2);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.tzOffset, fastStringBuffer);
        }
        return fastStringBuffer.toString();
    }

    public ItemType getItemType() {
        return Type.DATE_TYPE;
    }

    public CalendarValue removeTimezone() throws XPathException {
        return (CalendarValue)((DateTimeValue)this.convert(519, null)).removeTimezone().convert(521, null);
    }

    public CalendarValue setTimezone(SecondsDurationValue secondsDurationValue) throws XPathException {
        return (CalendarValue)((DateTimeValue)this.convert(519, null)).setTimezone(secondsDurationValue).convert(521, null);
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateValue.class$("java.util.Date")) : class$java$util$Date)) {
            return this.getUTCDate();
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = DateValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of date to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.calendar.get(1));
            }
            case 2: {
                return new IntegerValue(this.calendar.get(2) + 1);
            }
            case 3: {
                return new IntegerValue(this.calendar.get(5));
            }
            case 7: {
                if (this.zoneSpecified) {
                    return SecondsDurationValue.fromMilliseconds(this.tzOffset * 60000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof DateValue)) {
            throw new ClassCastException("Date values are not comparable to " + object.getClass());
        }
        int n = this.getUTCDate().compareTo(((DateValue)object).getUTCDate());
        if (n == 0) {
            return ((DateValue)object).tzOffset - this.tzOffset;
        }
        return n;
    }

    public int compareTo(CalendarValue calendarValue, ConversionContext conversionContext) {
        return this.compareTo(calendarValue);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getUTCDate().hashCode() + new Integer(this.tzOffset).hashCode();
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            int n = (int)durationValue.getLengthInSeconds() / 86400;
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(5, n);
            return new DateValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
        }
        if (durationValue instanceof MonthDurationValue) {
            int n = ((MonthDurationValue)durationValue).getLengthInMonths();
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(2, n);
            return new DateValue(gregorianCalendar, this.zoneSpecified, this.tzOffset);
        }
        DynamicError dynamicError = new DynamicError("Date arithmetic is not supported on xs:duration, only on its subtypes");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue, ConversionContext conversionContext) throws XPathException {
        if (!(calendarValue instanceof DateValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a date, but the second is not");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        return super.subtract(calendarValue, conversionContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

