/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class GDayValue
extends DateValue {
    private static Pattern regex = Pattern.compile("---([0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    public GDayValue() {
    }

    public GDayValue(CharSequence charSequence) throws XPathException {
        Matcher matcher = regex.matcher(charSequence);
        if (!matcher.matches()) {
            throw new DynamicError("Cannot convert '" + charSequence + "' to a gDay");
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = "2000-01-" + string + (string2 == null ? "" : string2);
        this.setLexicalValue(string3);
    }

    public GDayValue(GregorianCalendar gregorianCalendar, boolean bl, int n) {
        super(gregorianCalendar, bl, n);
    }

    public ItemType getItemType() {
        return Type.G_DAY_TYPE;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 525: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert gDay to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        fastStringBuffer.append("---");
        DateTimeValue.appendString(fastStringBuffer, this.calendar.get(5), 2);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.tzOffset, fastStringBuffer);
        }
        return fastStringBuffer.toString();
    }
}

