/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ValidationErrorValue;

public abstract class NumericValue
extends AtomicValue
implements Comparable {
    public static NumericValue parseNumber(String string) {
        if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
            return new DoubleValue(Double.parseDouble(string));
        }
        if (string.indexOf(46) >= 0) {
            AtomicValue atomicValue = DecimalValue.makeDecimalValue(string, true);
            if (atomicValue instanceof ValidationErrorValue) {
                return DoubleValue.NaN;
            }
            return (NumericValue)atomicValue;
        }
        AtomicValue atomicValue = IntegerValue.stringToInteger(string);
        if (atomicValue instanceof ValidationErrorValue) {
            return DoubleValue.NaN;
        }
        return (NumericValue)atomicValue;
    }

    public double getDoubleValue() {
        try {
            return ((DoubleValue)this.convert(517, null)).getDoubleValue();
        }
        catch (XPathException xPathException) {
            return Double.NaN;
        }
    }

    public boolean isNaN() {
        return false;
    }

    public static boolean isInteger(AtomicValue atomicValue) {
        if (atomicValue instanceof IntegerValue) {
            return true;
        }
        if (atomicValue instanceof BigIntegerValue) {
            return true;
        }
        return !atomicValue.hasBuiltInType() && NumericValue.isInteger(atomicValue.getPrimitiveValue());
    }

    public long longValue() throws XPathException {
        return ((IntegerValue)this.convert(532, null)).longValue();
    }

    public abstract NumericValue negate();

    public abstract NumericValue floor();

    public abstract NumericValue ceiling();

    public abstract NumericValue round();

    public abstract NumericValue roundToHalfEven(int var1);

    public abstract double signum();

    public abstract NumericValue arithmetic(int var1, NumericValue var2, XPathContext var3) throws XPathException;

    public abstract boolean isWholeNumber();

    public int compareTo(Object object) {
        double d;
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            return this.compareTo(((AtomicValue)object).getPrimitiveValue());
        }
        if (!(object instanceof NumericValue)) {
            throw new ClassCastException("Numeric values are not comparable to " + object.getClass());
        }
        double d2 = this.getDoubleValue();
        if (d2 == (d = ((NumericValue)object).getDoubleValue())) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    public final boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static ItemType promote(ItemType itemType, ItemType itemType2) {
        ItemType itemType3;
        ItemType itemType4 = Type.isSubType(itemType, Type.NUMBER_TYPE) ? itemType : Type.DOUBLE_TYPE;
        ItemType itemType5 = itemType3 = Type.isSubType(itemType2, Type.NUMBER_TYPE) ? itemType2 : Type.DOUBLE_TYPE;
        if (itemType4 == itemType3) {
            return itemType4;
        }
        if (itemType4 == Type.DOUBLE_TYPE || itemType3 == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (itemType4 == Type.FLOAT_TYPE || itemType3 == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (itemType4 == Type.DECIMAL_TYPE || itemType3 == Type.DECIMAL_TYPE) {
            return Type.DECIMAL_TYPE;
        }
        return Type.INTEGER_TYPE;
    }

    public abstract int hashCode();

    public String toString() {
        return this.getStringValue();
    }
}

