/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.saxon.Configuration;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class QNameValue
extends AtomicValue {
    private String prefix;
    private String uri;
    private String localPart;
    static /* synthetic */ Class class$net$sf$saxon$value$QNameValue;
    static /* synthetic */ Class class$java$lang$String;

    public QNameValue(NamePool namePool, int n) {
        this.prefix = namePool.getPrefix(n);
        this.uri = namePool.getURI(n);
        this.localPart = namePool.getLocalName(n);
    }

    public QNameValue(String string, String string2, String string3) throws XPathException {
        if (!XMLChar.isValidNCName(string3)) {
            DynamicError dynamicError = new DynamicError("Malformed local name in QName: '" + string3 + '\'');
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.prefix = string == null ? "" : string;
        this.uri = string2 == null ? "" : string2;
        this.localPart = string3;
    }

    public static AtomicValue castToQName(StringValue stringValue, AtomicType atomicType, StaticContext staticContext) throws XPathException {
        try {
            String string;
            CharSequence charSequence = stringValue.getStringValueCS();
            String[] stringArray = Name.getQNameParts(charSequence);
            if ("".equals(stringArray[0])) {
                string = "";
            } else {
                string = staticContext.getURIForPrefix(stringArray[0]);
                if (string == null) {
                    StaticError staticError = new StaticError("Prefix '" + stringArray[0] + "' has not been declared");
                    throw staticError;
                }
            }
            if (atomicType.getFingerprint() == 530) {
                return new QNameValue(stringArray[0], string, stringArray[1]);
            }
            if (Type.isSubType(atomicType, Type.QNAME_TYPE)) {
                QNameValue qNameValue = new QNameValue(stringArray[0], string, stringArray[1]);
                AtomicValue atomicValue = atomicType.makeDerivedValue(qNameValue, charSequence, true);
                if (atomicValue instanceof ValidationErrorValue) {
                    throw ((ValidationErrorValue)atomicValue).getException();
                }
                return atomicValue;
            }
            NotationValue notationValue = new NotationValue(stringArray[0], string, stringArray[1]);
            AtomicValue atomicValue = atomicType.makeDerivedValue(notationValue, charSequence, true);
            if (atomicValue instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)atomicValue).getException();
            }
            return atomicValue;
        }
        catch (QNameException qNameException) {
            StaticError staticError = new StaticError(qNameException);
            throw staticError;
        }
    }

    public String getStringValue() {
        if ("".equals(this.prefix)) {
            return this.localPart;
        }
        return this.prefix + ':' + this.localPart;
    }

    public String getClarkName() {
        if ("".equals(this.uri)) {
            return this.localPart;
        }
        return '{' + this.uri + '}' + this.localPart;
    }

    public String getLocalName() {
        return this.localPart;
    }

    public String getNamespaceURI() {
        return "".equals(this.uri) ? null : this.uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public AtomicValue getComponent(int n) {
        if (n == 8) {
            return RestrictedStringValue.makeRestrictedString(this.localPart, 559, false);
        }
        if (n == 9) {
            return new AnyURIValue(this.uri);
        }
        if (n == 10) {
            return RestrictedStringValue.makeRestrictedString(this.prefix, 559, false);
        }
        throw new UnsupportedOperationException("Component of QName must be URI, Local Name, or Prefix");
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 530: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert QName to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public ItemType getItemType() {
        return Type.QNAME_TYPE;
    }

    public boolean equals(Object object) {
        QNameValue qNameValue = (QNameValue)object;
        return this.localPart.equals(qNameValue.localPart) && this.uri.equals(qNameValue.uri);
    }

    public int hashCode() {
        return this.localPart.hashCode() ^ this.uri.hashCode();
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$QNameValue == null ? (class$net$sf$saxon$value$QNameValue = QNameValue.class$("net.sf.saxon.value.QNameValue")) : class$net$sf$saxon$value$QNameValue)) {
            return this;
        }
        if (clazz.getClass().getName().equals("javax.xml.namespace.QName")) {
            return this.makeQName(xPathContext.getController().getConfiguration());
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of QName to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public String toString() {
        return "QName(\"" + this.uri + "\", \"" + this.localPart + ')';
    }

    public Object makeQName(Configuration configuration) {
        try {
            Class clazz = configuration.getClass("javax.xml.namespace.QName", false, null);
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = QNameValue.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = QNameValue.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = QNameValue.class$("java.lang.String")) : class$java$lang$String};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new String[]{this.uri, this.localPart, this.prefix};
            Object t = constructor.newInstance(objectArray);
            return t;
        }
        catch (XPathException xPathException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

