/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Comparator;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public ItemType getItemType() {
        return Type.UNTYPED_ATOMIC_TYPE;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        int n = builtInAtomicType.getFingerprint();
        if (n == 513) {
            if (this.value.length() == 0) {
                return StringValue.EMPTY_STRING;
            }
            return new StringValue(this.value);
        }
        if (n == 517 || n == 646) {
            if (this.doubleValue == null) {
                AtomicValue atomicValue = super.convertPrimitive(builtInAtomicType, bl, conversionContext);
                if (atomicValue instanceof DoubleValue) {
                    this.doubleValue = (DoubleValue)atomicValue;
                }
                return atomicValue;
            }
            return this.doubleValue;
        }
        return super.convertPrimitive(builtInAtomicType, bl, conversionContext);
    }

    public int compareTo(Object object, Comparator comparator, ConversionContext conversionContext) {
        if (object instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = (DoubleValue)this.convert(517, null);
                }
                catch (XPathException xPathException) {
                    throw new ClassCastException("Cannot convert untyped value \"" + this.getStringValueCS() + "\" to a double");
                }
            }
            return this.doubleValue.compareTo(object);
        }
        if (object instanceof StringValue) {
            return comparator.compare(this.getStringValue(), ((StringValue)object).getStringValue());
        }
        if (object instanceof AtomicValue) {
            AtomicValue atomicValue = this.convert((AtomicType)((Value)object).getItemType(), conversionContext, true);
            if (atomicValue instanceof ValidationErrorValue) {
                throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + ((Value)object).getItemType());
            }
            if (!(atomicValue instanceof Comparable)) {
                throw new ClassCastException("Type " + ((Value)object).getItemType() + " is not ordered");
            }
            return ((Comparable)((Object)atomicValue)).compareTo(object);
        }
        return comparator.compare(this.getStringValue(), object.toString());
    }
}

