/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.SourceLocator;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.Variable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.xpath.JAXPVariable;
import net.sf.saxon.xpath.XPathFunctionLibrary;

public class StandaloneContext
implements StaticContext,
NamespaceResolver {
    private NamePool namePool;
    private HashMap namespaces = new HashMap(10);
    private HashMap collations = new HashMap(10);
    private HashMap variables = new HashMap(20);
    private SlotManager stackFrameMap;
    private String defaultCollationName = null;
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private FunctionLibrary functionLibrary;
    private XPathFunctionLibrary xpathFunctionLibrary;
    private String defaultFunctionNamespace = "http://www.w3.org/2005/04/xpath-functions";
    private short defaultElementNamespace = 0;
    private boolean backwardsCompatible = false;
    private NamespaceContext namespaceContext;
    private XPathVariableResolver variableResolver;

    public StandaloneContext() {
        this(new Configuration());
    }

    public StandaloneContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.stackFrameMap = configuration.makeSlotManager();
        this.clearNamespaces();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new SystemFunctionLibrary(0));
        functionLibraryList.addFunctionLibrary((FunctionLibrary)this.getConfiguration().getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new ConstructorFunctionLibrary(this.getConfiguration()));
        if (configuration.isAllowExternalFunctions()) {
            this.xpathFunctionLibrary = new XPathFunctionLibrary();
            functionLibraryList.addFunctionLibrary((FunctionLibrary)this.xpathFunctionLibrary);
            functionLibraryList.addFunctionLibrary(configuration.getExtensionBinder());
        }
        this.functionLibrary = functionLibraryList;
    }

    public StandaloneContext(NodeInfo nodeInfo) {
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            throw new IllegalArgumentException("The node used to establish a standalone context must be in a tree whose root is a document node");
        }
        this.namePool = documentInfo.getNamePool();
        this.setNamespaces(nodeInfo);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        this.namespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xdt", "http://www.w3.org/2005/04/xpath-datatypes");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo nodeInfo) {
        this.namespaces.clear();
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            this.declareNamespace(nodeInfo2.getLocalPart(), nodeInfo2.getStringValue());
        }
        return;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void declareCollation(String string, Comparator comparator, boolean bl) {
        this.collations.put(string, comparator);
        if (bl) {
            this.defaultCollationName = string;
        }
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public Variable declareVariable(String string, Object object) throws XPathException {
        String string2;
        String string3;
        Object object2;
        try {
            object2 = Name.getQNameParts((CharSequence)string);
            string3 = object2[0];
            string2 = object2[1];
        }
        catch (QNameException qNameException) {
            throw new StaticError("Invalid QName for variable: " + string);
        }
        object2 = "";
        if (!"".equals(string3)) {
            object2 = this.getURIForPrefix(string3);
        }
        Variable variable = Variable.make((String)string, (Configuration)this.getConfiguration());
        if (object instanceof ValueRepresentation) {
            variable.setXPathValue((ValueRepresentation)object);
        } else {
            variable.setValue(object);
        }
        int n = this.namePool.allocate(string3, (String)object2, string2) & 0xFFFFF;
        this.variables.put(new Integer(n), variable);
        this.stackFrameMap.allocateSlotNumber(n);
        return variable;
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.variableResolver = xPathVariableResolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (this.xpathFunctionLibrary != null) {
            this.xpathFunctionLibrary.setXPathFunctionResolver(xPathFunctionResolver);
        }
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        if (this.xpathFunctionLibrary != null) {
            return this.xpathFunctionLibrary.getXPathFunctionResolver();
        }
        return null;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        System.err.println(string);
    }

    public String getSystemId() {
        return "";
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.getURIForPrefix(string, false);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("") && !bl) {
            return "";
        }
        String string2 = (String)this.namespaces.get(string);
        if (string2 == null && this.namespaceContext != null) {
            return this.namespaceContext.getNamespaceURI(string);
        }
        return string2;
    }

    public Iterator iteratePrefixes() {
        return this.namespaces.keySet().iterator();
    }

    public VariableDeclaration bindVariable(int n) throws StaticError {
        Variable variable = (Variable)this.variables.get(new Integer(n));
        if (variable != null) {
            return variable;
        }
        if (this.variableResolver != null) {
            QNameValue qNameValue = new QNameValue(this.namePool, n);
            return new JAXPVariable(qNameValue, this.variableResolver);
        }
        throw new StaticError("Undeclared variable in a standalone expression");
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public Comparator getCollation(String string) {
        try {
            return CollationFactory.makeCollationFromURI((String)string, (Configuration)this.getConfiguration());
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return "http://www.w3.org/2005/04/xpath-functions/collation/codepoint";
    }

    public void setDefaultElementNamespace(String string) {
        this.defaultElementNamespace = this.namePool.allocateCodeForURI(string);
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setBackwardsCompatibilityMode(boolean bl) {
        this.backwardsCompatible = true;
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    public boolean isImportedSchema(String string) {
        return false;
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        return true;
    }
}

