/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.xom.NodeWrapper;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;
    private HashMap idIndex;

    public DocumentWrapper(Document document, String string, Configuration configuration) {
        super((Node)document, null, 0);
        this.node = document;
        this.nodeKind = (short)9;
        this.baseURI = string;
        this.docWrapper = this;
        this.setConfiguration(configuration);
    }

    public VirtualNode wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.documentNumber = configuration.getNamePool().allocateDocumentNumber((NodeInfo)this);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String string) {
        if (this.idIndex == null) {
            this.idIndex = new HashMap(50);
            Document document = (Document)this.node;
            this.buildIDIndex(document.getRootElement());
        }
        return (NodeInfo)this.idIndex.get(string);
    }

    private void buildIDIndex(Element element) {
        Node node;
        int n = element.getChildCount();
        while (--n >= 0) {
            node = element.getChild(n);
            if (!(node instanceof Element)) continue;
            this.buildIDIndex((Element)node);
        }
        n = element.getAttributeCount();
        while (--n >= 0) {
            node = element.getAttribute(n);
            if (node.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(node.getValue(), this.wrap((Node)element));
        }
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }
}

