/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public class AttrOverNodeInfo
extends NodeOverNodeInfo
implements Attr {
    public String getName() {
        return this.node.getDisplayName();
    }

    public String getValue() {
        return this.node.getStringValue();
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        AttrOverNodeInfo.disallowUpdate();
    }

    public Element getOwnerElement() {
        if (this.node.getNodeKind() != 2) {
            throw new UnsupportedOperationException("This method is defined only on attribute nodes");
        }
        return (Element)((Object)AttrOverNodeInfo.wrap(this.node.getParent()));
    }

    public TypeInfo getSchemaTypeInfo() {
        int n = this.node.getTypeAnnotation();
        if (n == -1) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), this.node.getConfiguration().getSchemaType(n));
    }
}

