/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.event.Emitter;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMEmitter
extends Emitter {
    protected Node currentNode;
    protected Document document;
    private boolean canNormalize = true;

    public void open() {
    }

    public void close() {
    }

    public void startDocument(int n) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        String string = this.namePool.getDisplayName(n);
        String string2 = this.namePool.getURI(n);
        try {
            Element element = this.document.createElementNS(string2, string);
            this.currentNode.appendChild(element);
            this.currentNode = element;
        }
        catch (DOMException dOMException) {
            throw new DynamicError((Throwable)dOMException);
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        try {
            String string = this.namePool.getPrefixFromNamespaceCode(n);
            String string2 = this.namePool.getURIFromNamespaceCode(n);
            Element element = (Element)this.currentNode;
            if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                if (string.equals("")) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
                } else {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
                }
            }
        }
        catch (DOMException dOMException) {
            throw new DynamicError((Throwable)dOMException);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        String string = this.namePool.getDisplayName(n);
        String string2 = this.namePool.getURI(n);
        try {
            Element element = (Element)this.currentNode;
            element.setAttributeNS(string2, string, ((Object)charSequence).toString());
        }
        catch (DOMException dOMException) {
            throw new DynamicError((Throwable)dOMException);
        }
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable throwable) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        try {
            Text text = this.document.createTextNode(((Object)charSequence).toString());
            this.currentNode.appendChild(text);
        }
        catch (DOMException dOMException) {
            throw new DynamicError((Throwable)dOMException);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        try {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, ((Object)charSequence).toString());
            this.currentNode.appendChild(processingInstruction);
        }
        catch (DOMException dOMException) {
            throw new DynamicError((Throwable)dOMException);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        try {
            Comment comment = this.document.createComment(((Object)charSequence).toString());
            this.currentNode.appendChild(comment);
        }
        catch (DOMException dOMException) {
            throw new DynamicError((Throwable)dOMException);
        }
    }

    public void setNode(Node node) {
        if (node == null) {
            return;
        }
        this.currentNode = node;
        this.document = node instanceof Document ? (Document)node : this.currentNode.getOwnerDocument();
    }
}

