/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;

    public DocumentWrapper(Document document, String string, Configuration configuration) {
        super(document, null, 0);
        this.node = document;
        this.nodeKind = (short)9;
        this.baseURI = string;
        this.docWrapper = this;
        this.setConfiguration(configuration);
    }

    public NodeWrapper wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        if (node.getOwnerDocument() == this.node) {
            return this.makeWrapper(node, this);
        }
        throw new IllegalArgumentException("DocumentWrapper#wrap: supplied node does not belong to the wrapped DOM document");
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        NamePool namePool = configuration.getNamePool();
        this.documentNumber = namePool.allocateDocumentNumber((NodeInfo)this);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String string) {
        Element element = ((Document)this.node).getElementById(string);
        if (element == null) {
            return null;
        }
        return this.wrap(element);
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof DocumentWrapper)) {
            return false;
        }
        return this.node == ((DocumentWrapper)nodeInfo).node;
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }
}

