/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import org.apache.xalan.stree.AttrImpl;
import org.apache.xalan.stree.AttrImplNS;
import org.apache.xalan.stree.Child;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.NameSpaceDecl;
import org.apache.xalan.stree.Parent;
import org.apache.xml.utils.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class ElementImpl
extends Parent
implements Attributes,
NamedNodeMap {
    private String m_name;
    private short m_attrsEnd = 0;
    private AttrImpl m_firstAttr;
    private AttrImpl m_lastAttr;

    ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.m_name = string;
    }

    ElementImpl(DocumentImpl documentImpl, String string, Attributes attributes) {
        super(documentImpl);
        this.m_name = string;
        this.setAttributes(attributes);
    }

    public Attr createAttribute(String string) throws DOMException {
        AttrImpl attrImpl = QName.isXMLNSDecl(string) ? new NameSpaceDecl(this.getDocumentImpl(), "http://www.w3.org/2000/xmlns/", string, "") : new AttrImpl(this.getDocumentImpl(), string, "");
        boolean bl = false;
        AttrImpl attrImpl2 = this.m_firstAttr;
        while (attrImpl2 != null) {
            if (attrImpl2.getNodeName().equals(string)) {
                if (attrImpl2.m_prev != null) {
                    attrImpl2.m_prev.m_next = attrImpl2.m_next;
                }
                if (this.m_next != null) {
                    attrImpl2.m_next.m_prev = attrImpl2.m_prev;
                }
                attrImpl2.m_next = null;
                attrImpl2.m_prev = null;
                bl = true;
                break;
            }
            attrImpl2 = (AttrImpl)attrImpl2.m_next;
        }
        if (!bl) {
            if (this.m_firstAttr == null) {
                this.m_firstAttr = attrImpl;
            } else {
                this.m_lastAttr.m_next = attrImpl;
                attrImpl.m_prev = this.m_lastAttr;
            }
            this.m_lastAttr = attrImpl;
            this.m_doc.incrementDocOrderCount();
            attrImpl.setUid(this.m_doc.getDocOrderCount());
            attrImpl.setParent(this);
            attrImpl.setLevel((short)(this.getLevel() + 1));
            this.m_attrsEnd = (short)(this.m_attrsEnd + 1);
        }
        return attrImpl;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        AttrImplNS attrImplNS = new AttrImplNS(this.getDocumentImpl(), string, string2, "");
        boolean bl = false;
        AttrImpl attrImpl = this.m_firstAttr;
        while (attrImpl != null) {
            String string3 = attrImpl.getNamespaceURI();
            if (string3 == null) {
                string3 = "";
            }
            if (attrImpl.getLocalName().equals(attrImplNS.getLocalName()) && string3.equals(attrImplNS.getNamespaceURI())) {
                if (attrImpl.m_prev != null) {
                    attrImpl.m_prev.m_next = attrImpl.m_next;
                }
                if (this.m_next != null) {
                    attrImpl.m_next.m_prev = attrImpl.m_prev;
                }
                attrImpl.m_next = null;
                attrImpl.m_prev = null;
                bl = true;
                break;
            }
            attrImpl = (AttrImpl)attrImpl.m_next;
        }
        if (!bl) {
            if (this.m_firstAttr == null) {
                this.m_firstAttr = attrImplNS;
            } else {
                this.m_lastAttr.m_next = attrImplNS;
                attrImplNS.m_prev = this.m_lastAttr;
            }
            this.m_lastAttr = attrImplNS;
            this.m_doc.incrementDocOrderCount();
            attrImplNS.setUid(this.m_doc.getDocOrderCount());
            attrImplNS.setParent(this);
            attrImplNS.setLevel((short)(this.getLevel() + 1));
            this.m_attrsEnd = (short)(this.m_attrsEnd + 1);
        }
        return attrImplNS;
    }

    public int getAttrCount() {
        DocumentImpl documentImpl = this.m_doc;
        synchronized (documentImpl) {
            short s = this.m_attrsEnd;
            Object var3_3 = null;
            return s;
        }
    }

    public String getAttribute(String string) {
        return this.getValue(string);
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AttrImpl getChildAttribute(int n) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (n < 0) {
            return null;
        }
        DocumentImpl documentImpl = this.m_doc;
        synchronized (documentImpl) {
            if (this.m_firstAttr == null) return null;
            Child child = this.m_firstAttr;
            int n2 = 0;
            while (n2 < n) {
                if (child == null) {
                    return null;
                }
                child = child.m_next;
                ++n2;
            }
            return child;
        }
    }

    public int getChildCount() {
        if (!this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount;
    }

    public int getIndex(String string) {
        int n = 0;
        while (n < this.getAttrCount()) {
            AttrImpl attrImpl = this.getChildAttribute(n);
            if (attrImpl.getNodeName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        int n = 0;
        while (n < this.getAttrCount()) {
            AttrImpl attrImpl = this.getChildAttribute(n);
            if (attrImpl.getLocalName().equals(string2) && attrImpl.getNamespaceURI().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getLength() {
        return this.getAttrCount();
    }

    public String getLocalName() {
        return this.m_name;
    }

    public String getLocalName(int n) {
        AttrImpl attrImpl = this.getChildAttribute(n);
        if (attrImpl != null) {
            return attrImpl.getLocalName();
        }
        return null;
    }

    public Node getNamedItem(String string) {
        return this.getChildAttribute(this.getIndex(string));
    }

    public Node getNamedItemNS(String string, String string2) {
        return this.getChildAttribute(this.getIndex(string, string2));
    }

    public String getNodeName() {
        return this.m_name;
    }

    public short getNodeType() {
        return 1;
    }

    public String getQName(int n) {
        AttrImpl attrImpl = this.getChildAttribute(n);
        if (attrImpl != null) {
            return attrImpl.getNodeName();
        }
        return null;
    }

    public String getTagName() {
        return this.m_name;
    }

    public String getType(int n) {
        AttrImpl attrImpl = this.getChildAttribute(n);
        if (attrImpl != null) {
            return Integer.toString(attrImpl.getNodeType());
        }
        return null;
    }

    public String getType(String string) {
        int n = 0;
        while (n < this.getAttrCount()) {
            AttrImpl attrImpl = this.getChildAttribute(n);
            if (attrImpl.getNodeName().equals(string)) {
                return Integer.toString(attrImpl.getNodeType());
            }
            ++n;
        }
        return null;
    }

    public String getType(String string, String string2) {
        int n = 0;
        while (n < this.getAttrCount()) {
            AttrImpl attrImpl = this.getChildAttribute(n);
            if (attrImpl.getLocalName().equals(string2) && attrImpl.getNamespaceURI().equals(string)) {
                return Integer.toString(attrImpl.getNodeType());
            }
            ++n;
        }
        return null;
    }

    public String getURI(int n) {
        AttrImpl attrImpl = this.getChildAttribute(n);
        if (attrImpl != null) {
            return attrImpl.getNamespaceURI();
        }
        return null;
    }

    public String getValue(int n) {
        AttrImpl attrImpl = this.getChildAttribute(n);
        if (attrImpl != null) {
            return attrImpl.getValue();
        }
        return null;
    }

    public String getValue(String string) {
        int n = 0;
        while (n < this.getAttrCount()) {
            AttrImpl attrImpl = this.getChildAttribute(n);
            if (attrImpl.getNodeName().equals(string)) {
                return attrImpl.getValue();
            }
            ++n;
        }
        return null;
    }

    public String getValue(String string, String string2) {
        int n = 0;
        while (n < this.getAttrCount()) {
            AttrImpl attrImpl = this.getChildAttribute(n);
            if (attrImpl.getLocalName().equals(string2) && attrImpl.getNamespaceURI().equals(string)) {
                return attrImpl.getValue();
            }
            ++n;
        }
        return null;
    }

    public Node item(int n) {
        return this.getChildAttribute(n);
    }

    public Node removeItem(int n) throws DOMException {
        AttrImpl attrImpl = this.m_firstAttr;
        int n2 = 0;
        while (attrImpl != null) {
            if (n2 == n) {
                if (attrImpl.m_prev != null) {
                    attrImpl.m_prev.m_next = attrImpl.m_next;
                }
                if (this.m_next != null) {
                    attrImpl.m_next.m_prev = attrImpl.m_prev;
                }
                attrImpl.m_next = null;
                attrImpl.m_prev = null;
                return attrImpl;
            }
            attrImpl = (AttrImpl)attrImpl.m_next;
            ++n2;
        }
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        int n = this.getIndex(string);
        return this.removeItem(n);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        int n = this.getIndex(string, string2);
        return this.removeItem(n);
    }

    public void setAttribute(String string, String string2) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)this.createAttribute(string);
        attrImpl.setValue(string2);
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        AttrImplNS attrImplNS = (AttrImplNS)this.createAttributeNS(string, string2);
        attrImplNS.setValue(string3);
    }

    public void setAttributes(Attributes attributes) throws DOMException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getURI(n);
            String string2 = attributes.getQName(n);
            AttrImpl attrImpl = string != null || string2.indexOf(58) > 0 ? (AttrImplNS)this.createAttributeNS(string, string2) : (AttrImpl)this.createAttribute(string2);
            attrImpl.setValue(attributes.getValue(n));
            ++n;
        }
    }

    public void setIDAttribute(String string) {
        this.getDocumentImpl().setIDAttribute(string, this);
    }

    public Node setNamedItem(Node node) throws DOMException {
        this.setAttribute(((Attr)node).getName(), ((Attr)node).getValue());
        return this.getChildAttribute(this.getIndex(((Attr)node).getName()));
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.setAttributeNS(((Attr)node).getNamespaceURI(), ((Attr)node).getName(), ((Attr)node).getValue());
        return this.getChildAttribute(this.getIndex(((Attr)node).getNamespaceURI(), ((Attr)node).getName()));
    }
}

