/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import javax.xml.transform.TransformerException;
import org.apache.xalan.stree.Child;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.SaxEventDispatch;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.XPathContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Parent
extends Child {
    protected int m_posInChildList;
    protected int m_childCount = 0;
    boolean m_isComplete = false;
    Child m_last;
    Child m_first;

    public Parent(DocumentImpl documentImpl) {
        super(documentImpl);
    }

    public Node appendChild(Node node) throws DOMException {
        block6: {
            TransformerImpl transformerImpl;
            SourceTreeHandler sourceTreeHandler;
            Child child = (Child)node;
            DocumentImpl documentImpl = this.m_doc;
            child.m_parent = this;
            ++this.m_childCount;
            if (child.m_uid == 0) {
                child.m_uid = ++this.m_doc.m_docOrderCount;
            }
            child.m_level = (short)(this.m_level + 1);
            if (this.m_first == null) {
                this.m_first = child;
            } else {
                child.m_prev = this.m_last;
                this.m_last.m_next = child;
            }
            this.m_last = child;
            if (child.getNodeType() != 1 || (sourceTreeHandler = documentImpl.getSourceTreeHandler()) == null || !sourceTreeHandler.m_shouldCheckWhitespace || (transformerImpl = sourceTreeHandler.getTransformerImpl()) == null) break block6;
            StylesheetRoot stylesheetRoot = transformerImpl.getStylesheet();
            try {
                WhiteSpaceInfo whiteSpaceInfo;
                ElementImpl elementImpl = (ElementImpl)child;
                if (documentImpl.m_xpathContext == null) {
                    documentImpl.m_xpathContext = new XPathContext(documentImpl);
                }
                boolean bl = (whiteSpaceInfo = stylesheetRoot.getWhiteSpaceInfo(documentImpl.m_xpathContext, elementImpl)) == null ? sourceTreeHandler.getShouldStripWhitespace() : whiteSpaceInfo.getShouldStripSpace();
                sourceTreeHandler.setShouldStripWhitespace(bl);
            }
            catch (TransformerException transformerException) {}
        }
        return node;
    }

    public void dispatchCharactersEvent(ContentHandler contentHandler) throws SAXException {
        Node node = this.getFirstChild();
        while (node != null) {
            short s = node.getNodeType();
            if (s != 8 && s != 7) {
                ((SaxEventDispatch)((Object)node)).dispatchCharactersEvent(contentHandler);
            }
            node = node.getNextSibling();
        }
    }

    public Child getChild(int n) throws ArrayIndexOutOfBoundsException, NullPointerException {
        Child child;
        if (n < 0) {
            return null;
        }
        if (n >= this.m_childCount && !this.isComplete()) {
            child = this.m_doc;
            synchronized (child) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (n >= this.m_childCount) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        if (n < this.m_childCount) {
            child = this.m_first;
            int n2 = 0;
            while (child != null) {
                if (n2 == n) {
                    return child;
                }
                child = child.m_next;
                ++n2;
            }
        }
        return null;
    }

    public int getChildCount() {
        if (!this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount;
    }

    public int getChildUID(int n) {
        Child child = this.getChild(n);
        return child != null ? child.getUid() : -1;
    }

    public Node getFirstChild() {
        if (this.m_first != null) {
            return this.m_first;
        }
        if (!this.m_isComplete) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (this.m_first == null) continue;
                        Child child = this.m_first;
                        Object var3_3 = null;
                        return child;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_first;
    }

    public Node getLastChild() {
        try {
            return this.getChild(this.getChildCount() - 1);
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    public boolean hasChildNodes() {
        if (this.m_childCount != 0) {
            return true;
        }
        if (!this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (this.m_childCount == 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount != 0;
    }

    public boolean isComplete() {
        if (!this.m_isComplete && this.m_doc.m_exceptionThrown != null) {
            this.throwParseError(this.m_doc.m_exceptionThrown);
        }
        return this.m_isComplete;
    }

    public void setComplete(boolean bl) {
        this.m_isComplete = bl;
    }

    protected void throwParseError(Exception exception) {
        this.m_isComplete = true;
        super.throwParseError(exception);
    }
}

