/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class AttributeIterator
extends LocPathIterator {
    private transient NamedNodeMap m_attributeList;
    private transient int m_attrListPos = 0;
    private transient int m_nAttrs = 0;

    public AttributeIterator(Compiler compiler, int n, int n2) throws TransformerException {
        super(compiler, n, n2, false);
        int n3 = OpMap.getFirstChildPos(n);
        int n4 = compiler.getWhatToShow(n3);
        if ((n4 & 0x43) == 0 || n4 == -1) {
            this.initNodeTest(n4);
        } else {
            this.initNodeTest(n4, compiler.getStepNS(n3), compiler.getStepLocalName(n3));
        }
        this.initPredicateInfo(compiler, n3);
    }

    public Object clone() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)super.clone();
        return locPathIterator;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        AttributeIterator attributeIterator = (AttributeIterator)super.cloneWithReset();
        attributeIterator.m_attrListPos = 0;
        attributeIterator.resetProximityPositions();
        return attributeIterator;
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.m_nAttrs;
    }

    private void initAttrList() {
        if (this.m_context.getNodeType() == 1) {
            this.m_attrListPos = 0;
            this.m_attributeList = this.m_context.getAttributes();
            this.m_nAttrs = this.m_attributeList != null ? this.m_attributeList.getLength() : 0;
            if (this.m_nAttrs == 0) {
                this.m_foundLast = true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node nextNode() throws DOMException {
        Node node;
        int n;
        VariableStack variableStack;
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node node2 = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return node2;
        }
        if (this.m_foundLast) {
            return null;
        }
        if (this.m_attributeList == null) {
            this.initAttrList();
            this.resetProximityPositions();
        }
        if (this.m_varStackPos != -1) {
            variableStack = this.m_execContext.getVarStack();
            n = variableStack.getSearchStart();
            variableStack.setSearchStart(this.m_varStackPos);
            variableStack.pushContextPosition(this.m_varStackContext);
        } else {
            variableStack = null;
            n = 0;
        }
        try {
            Node node3;
            do {
                node3 = this.m_attributeList == null || this.m_attrListPos >= this.m_nAttrs ? null : this.m_attributeList.item(this.m_attrListPos++);
                this.m_lastFetched = node3;
            } while (node3 != null && this.acceptNode(node3) != 1 && node3 != null);
            if (node3 != null) {
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(this.m_lastFetched);
                }
                ++this.m_next;
                Node node4 = node3;
                Object var5_7 = null;
                if (this.m_varStackPos == -1) return node4;
                variableStack.setSearchStart(n);
                variableStack.popContextPosition();
                return node4;
            }
            this.m_foundLast = true;
            node = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (this.m_varStackPos == -1) throw throwable;
            variableStack.setSearchStart(n);
            variableStack.popContextPosition();
            throw throwable;
        }
        Object var5_8 = null;
        if (this.m_varStackPos == -1) return node;
        variableStack.setSearchStart(n);
        variableStack.popContextPosition();
        return node;
    }
}

