/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;

public class WeblogicDeploymentTool
extends GenericDeploymentTool {
    public static final String PUBLICID_EJB11 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static final String PUBLICID_EJB20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static final String PUBLICID_WEBLOGIC_EJB = "-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB//EN";
    protected static final String DEFAULT_WL51_EJB11_DTD_LOCATION = "/weblogic/ejb/deployment/xml/ejb-jar.dtd";
    protected static final String DEFAULT_WL60_EJB11_DTD_LOCATION = "/weblogic/ejb20/dd/xml/ejb11-jar.dtd";
    protected static final String DEFAULT_WL60_EJB20_DTD_LOCATION = "/weblogic/ejb20/dd/xml/ejb20-jar.dtd";
    protected static final String DEFAULT_WL_DTD_LOCATION = "/weblogic/ejb/deployment/xml/weblogic-ejb-jar.dtd";
    protected static final String WL_DD = "weblogic-ejb-jar.xml";
    protected static final String WL_CMP_DD = "weblogic-cmp-rdbms-jar.xml";
    private String jarSuffix = ".jar";
    private String weblogicDTD;
    private String ejb11DTD;
    private boolean keepgenerated = false;
    private String additionalArgs = "";
    private boolean keepGeneric = false;
    private String compiler = null;
    private boolean alwaysRebuild = true;
    private boolean newCMP = false;
    private Path wlClasspath = null;

    public Path createWLClasspath() {
        if (this.wlClasspath == null) {
            this.wlClasspath = new Path(this.getTask().getProject());
        }
        return this.wlClasspath.createPath();
    }

    public void setWLClasspath(Path path) {
        this.wlClasspath = path;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public void setRebuild(boolean bl) {
        this.alwaysRebuild = bl;
    }

    public void setSuffix(String string) {
        this.jarSuffix = string;
    }

    public void setKeepgeneric(boolean bl) {
        this.keepGeneric = bl;
    }

    public void setKeepgenerated(String string) {
        this.keepgenerated = Boolean.valueOf(string);
    }

    public void setArgs(String string) {
        this.additionalArgs = string;
    }

    public void setWeblogicdtd(String string) {
        this.setEJBdtd(string);
    }

    public void setWLdtd(String string) {
        this.weblogicDTD = string;
    }

    public void setEJBdtd(String string) {
        this.ejb11DTD = string;
    }

    public void setOldCMP(boolean bl) {
        this.newCMP = !bl;
    }

    public void setNewCMP(boolean bl) {
        this.newCMP = bl;
    }

    protected DescriptorHandler getDescriptorHandler(File file) {
        DescriptorHandler descriptorHandler = new DescriptorHandler(file);
        descriptorHandler.registerDTD(PUBLICID_EJB11, DEFAULT_WL51_EJB11_DTD_LOCATION);
        descriptorHandler.registerDTD(PUBLICID_EJB11, DEFAULT_WL60_EJB11_DTD_LOCATION);
        descriptorHandler.registerDTD(PUBLICID_EJB11, this.ejb11DTD);
        descriptorHandler.registerDTD(PUBLICID_EJB20, DEFAULT_WL60_EJB20_DTD_LOCATION);
        Iterator iterator = ((AbstractList)this.getConfig().dtdLocations).iterator();
        while (iterator.hasNext()) {
            EjbJar.DTDLocation dTDLocation = (EjbJar.DTDLocation)iterator.next();
            descriptorHandler.registerDTD(dTDLocation.getPublicId(), dTDLocation.getLocation());
        }
        return descriptorHandler;
    }

    protected DescriptorHandler getWeblogicDescriptorHandler(final File file) {
        DescriptorHandler descriptorHandler = new DescriptorHandler(file){

            protected void processElement() {
                if (this.currentElement.equals("type-storage")) {
                    String string = this.currentText;
                    String string2 = string.substring("META-INF/".length(), string.length());
                    File file2 = new File(file, string2);
                    this.ejbFiles.put(string, file2);
                }
            }
        };
        descriptorHandler.registerDTD(PUBLICID_WEBLOGIC_EJB, this.weblogicDTD == null ? DEFAULT_WL_DTD_LOCATION : this.weblogicDTD);
        Iterator iterator = ((AbstractList)this.getConfig().dtdLocations).iterator();
        while (iterator.hasNext()) {
            EjbJar.DTDLocation dTDLocation = (EjbJar.DTDLocation)iterator.next();
            descriptorHandler.registerDTD(dTDLocation.getPublicId(), dTDLocation.getLocation());
        }
        return descriptorHandler;
    }

    protected void addVendorFiles(Hashtable hashtable, String string) {
        String string2 = this.usingBaseJarName() ? "" : string + this.getConfig().baseNameTerminator;
        File file = new File(this.getConfig().descriptorDir, string2 + WL_DD);
        if (!file.exists()) {
            this.log("Unable to locate weblogic deployment descriptor. It was expected to be in " + file.getPath(), 1);
            return;
        }
        hashtable.put("META-INF/weblogic-ejb-jar.xml", file);
        if (!this.newCMP) {
            this.log("The old method for locating CMP files has been DEPRECATED.", 3);
            this.log("Please adjust your weblogic descriptor and set newCMP=\"true\" to use the new CMP descriptor inclusion mechanism. ", 3);
            File file2 = new File(this.getConfig().descriptorDir, string2 + WL_CMP_DD);
            if (file2.exists()) {
                hashtable.put("META-INF/weblogic-cmp-rdbms-jar.xml", file2);
            }
        } else {
            try {
                File file3 = (File)hashtable.get("META-INF/ejb-jar.xml");
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                DescriptorHandler descriptorHandler = this.getWeblogicDescriptorHandler(file3.getParentFile());
                sAXParser.parse(new InputSource(new FileInputStream(file)), (HandlerBase)descriptorHandler);
                Hashtable hashtable2 = descriptorHandler.getFiles();
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    hashtable.put(string3, hashtable2.get(string3));
                }
            }
            catch (Exception exception) {
                String string4 = "Exception while adding Vendor specific files: " + exception.toString();
                throw new BuildException(string4, (Throwable)exception);
            }
        }
    }

    File getVendorOutputJarFile(String string) {
        return new File(this.getDestDir(), string + this.jarSuffix);
    }

    private void buildWeblogicJar(File file, File file2) {
        Java java = null;
        try {
            String string = this.additionalArgs;
            if (this.keepgenerated) {
                string = string + " -keepgenerated";
            }
            if (this.compiler != null) {
                string = string + " -compiler " + this.compiler;
            }
            string = string + " " + file.getPath() + " " + file2.getPath();
            java = (Java)this.getTask().getProject().createTask("java");
            java.setTaskName("ejbc");
            java.setClassname("weblogic.ejbc");
            Commandline.Argument argument = java.createArg();
            argument.setLine(string);
            Path path = this.wlClasspath;
            if (path == null) {
                path = this.getCombinedClasspath();
            }
            if (path != null) {
                java.setClasspath(path);
                java.setFork(true);
            } else {
                java.setFork(true);
            }
            this.log("Calling weblogic.ejbc for " + file.toString(), 3);
            java.execute();
        }
        catch (Exception exception) {
            String string = "Exception while calling ejbc. Details: " + exception.toString();
            throw new BuildException(string, (Throwable)exception);
        }
    }

    protected void writeJar(String string, File file, Hashtable hashtable) throws BuildException {
        File file2 = super.getVendorOutputJarFile(string);
        super.writeJar(string, file2, hashtable);
        if (this.alwaysRebuild || this.isRebuildRequired(file2, file)) {
            this.buildWeblogicJar(file2, file);
        }
        if (!this.keepGeneric) {
            this.log("deleting generic jar " + file2.toString(), 3);
            file2.delete();
        }
    }

    public void validateConfigured() throws BuildException {
        super.validateConfigured();
    }

    /*
     * Loose catch block
     */
    protected boolean isRebuildRequired(File file, File file2) {
        boolean bl;
        block40: {
            IOException iOException2222;
            ZipOutputStream zipOutputStream;
            File file3;
            ZipFile zipFile;
            ZipFile zipFile2;
            block37: {
                block36: {
                    bl = false;
                    zipFile2 = null;
                    zipFile = null;
                    file3 = null;
                    zipOutputStream = null;
                    this.log("Checking if weblogic Jar needs to be rebuilt for jar " + file2.getName(), 3);
                    if (file.exists() && file.isFile() && file2.exists() && file2.isFile()) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        Object object6;
                        zipFile2 = new JarFile(file);
                        zipFile = new JarFile(file2);
                        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                        Hashtable<Object, Object> hashtable3 = new Hashtable<Object, Object>();
                        Enumeration<JarEntry> enumeration = ((JarFile)zipFile2).entries();
                        while (enumeration.hasMoreElements()) {
                            object6 = enumeration.nextElement();
                            hashtable.put(((ZipEntry)object6).getName().replace('\\', '/'), object6);
                        }
                        object6 = ((JarFile)zipFile).entries();
                        while (object6.hasMoreElements()) {
                            object5 = (JarEntry)object6.nextElement();
                            hashtable2.put(((ZipEntry)object5).getName(), object5);
                        }
                        object5 = this.getClassLoaderFromJar(file);
                        Enumeration enumeration2 = hashtable.keys();
                        while (enumeration2.hasMoreElements()) {
                            object4 = (String)enumeration2.nextElement();
                            if (hashtable2.containsKey(object4)) {
                                object3 = (JarEntry)hashtable.get(object4);
                                JarEntry jarEntry = (JarEntry)hashtable2.get(object4);
                                if (((ZipEntry)object3).getCrc() == jarEntry.getCrc() && ((ZipEntry)object3).getSize() == jarEntry.getSize()) continue;
                                if (((ZipEntry)object3).getName().endsWith(".class")) {
                                    object2 = ((ZipEntry)object3).getName().replace(File.separatorChar, '.');
                                    object = ((ClassLoader)object5).loadClass((String)(object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(".class"))));
                                    if (((Class)object).isInterface()) {
                                        this.log("Interface " + ((Class)object).getName() + " has changed", 3);
                                        bl = true;
                                        break;
                                    }
                                    hashtable3.put(object4, object3);
                                    continue;
                                }
                                if (((ZipEntry)object3).getName().equals("META-INF/MANIFEST.MF")) break;
                                this.log("Non class file " + ((ZipEntry)object3).getName() + " has changed", 3);
                                bl = true;
                                break;
                            }
                            this.log("File " + (String)object4 + " not present in weblogic jar", 3);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.log("No rebuild needed - updating jar", 3);
                            file3 = new File(file2.getAbsolutePath() + ".temp");
                            if (file3.exists()) {
                                file3.delete();
                            }
                            zipOutputStream = new JarOutputStream(new FileOutputStream(file3));
                            zipOutputStream.setLevel(0);
                            object4 = hashtable2.elements();
                            while (object4.hasMoreElements()) {
                                int n;
                                object3 = new byte[1024];
                                object = (JarEntry)object4.nextElement();
                                if (((ZipEntry)object).getCompressedSize() == -1L || ((ZipEntry)object).getCompressedSize() == ((ZipEntry)object).getSize()) {
                                    zipOutputStream.setLevel(0);
                                } else {
                                    zipOutputStream.setLevel(9);
                                }
                                if (hashtable3.containsKey(((ZipEntry)object).getName())) {
                                    this.log("Updating Bean class from generic Jar " + ((ZipEntry)object).getName(), 3);
                                    object = (JarEntry)hashtable3.get(((ZipEntry)object).getName());
                                    object2 = ((JarFile)zipFile2).getInputStream((ZipEntry)object);
                                } else {
                                    object2 = ((JarFile)zipFile).getInputStream((ZipEntry)object);
                                }
                                ((JarOutputStream)zipOutputStream).putNextEntry(new JarEntry(((ZipEntry)object).getName()));
                                while ((n = ((InputStream)object2).read((byte[])object3)) != -1) {
                                    zipOutputStream.write((byte[])object3, 0, n);
                                }
                                ((InputStream)object2).close();
                            }
                        } else {
                            this.log("Weblogic Jar rebuild needed due to changed interface or XML", 3);
                        }
                        break block36;
                    }
                    bl = true;
                }
                Object var21_25 = null;
                if (zipFile2 == null) break block37;
                try {
                    zipFile2.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (zipOutputStream == null) break block40;
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException2222) {
                // empty catch block
            }
            file2.delete();
            file3.renameTo(file2);
            if (!file2.exists()) {
                bl = true;
            }
            break block40;
            {
                catch (ClassNotFoundException classNotFoundException) {
                    String string = "ClassNotFoundException while processing ejb-jar file. Details: " + classNotFoundException.getMessage();
                    throw new BuildException(string, (Throwable)classNotFoundException);
                }
                catch (IOException iOException3) {
                    String string = "IOException while processing ejb-jar file . Details: " + iOException3.getMessage();
                    throw new BuildException(string, (Throwable)iOException3);
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var21_26 = null;
                if (zipFile2 != null) {
                    try {
                        zipFile2.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                    file2.delete();
                    file3.renameTo(file2);
                    if (!file2.exists()) {
                        bl = true;
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    protected ClassLoader getClassLoaderFromJar(File file) throws IOException {
        Path path = new Path(this.getTask().getProject());
        path.setLocation(file);
        Path path2 = this.getCombinedClasspath();
        if (path2 != null) {
            path.append(path2);
        }
        return new AntClassLoader(this.getTask().getProject(), path);
    }
}

