/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jlink;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.jlink.jlink;
import org.apache.tools.ant.types.Path;

public class JlinkTask
extends MatchingTask {
    private File outfile = null;
    private Path mergefiles = null;
    private Path addfiles = null;
    private boolean compress = false;
    private String ps = System.getProperty("path.separator");

    public void setOutfile(File file) {
        this.outfile = file;
    }

    public Path createMergefiles() {
        if (this.mergefiles == null) {
            this.mergefiles = new Path(this.getProject());
        }
        return this.mergefiles.createPath();
    }

    public void setMergefiles(Path path) {
        if (this.mergefiles == null) {
            this.mergefiles = path;
        } else {
            this.mergefiles.append(path);
        }
    }

    public Path createAddfiles() {
        if (this.addfiles == null) {
            this.addfiles = new Path(this.getProject());
        }
        return this.addfiles.createPath();
    }

    public void setAddfiles(Path path) {
        if (this.addfiles == null) {
            this.addfiles = path;
        } else {
            this.addfiles.append(path);
        }
    }

    public void setCompress(boolean bl) {
        this.compress = bl;
    }

    public void execute() throws BuildException {
        if (this.outfile == null) {
            throw new BuildException("outfile attribute is required! Please set.");
        }
        if (!this.haveAddFiles() && !this.haveMergeFiles()) {
            throw new BuildException("addfiles or mergefiles required! Please set.");
        }
        this.log("linking:     " + this.outfile.getPath());
        this.log("compression: " + this.compress, 3);
        jlink jlink2 = new jlink();
        jlink2.setOutfile(this.outfile.getPath());
        jlink2.setCompression(this.compress);
        if (this.haveMergeFiles()) {
            this.log("merge files: " + this.mergefiles.toString(), 3);
            jlink2.addMergeFiles(this.mergefiles.list());
        }
        if (this.haveAddFiles()) {
            this.log("add files: " + this.addfiles.toString(), 3);
            jlink2.addAddFiles(this.addfiles.list());
        }
        try {
            jlink2.link();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception, ((Task)this).location);
        }
    }

    private boolean haveAddFiles() {
        return this.haveEntries(this.addfiles);
    }

    private boolean haveMergeFiles() {
        return this.haveEntries(this.mergefiles);
    }

    private boolean haveEntries(Path path) {
        if (path == null) {
            return false;
        }
        return path.size() > 0;
    }
}

