/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jlink;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.taskdefs.optional.jlink.ClassNameReader;

public class jlink {
    private String outfile = null;
    private Vector mergefiles = new Vector(10);
    private Vector addfiles = new Vector(10);
    private boolean compression = false;
    byte[] buffer = new byte[8192];

    public void setOutfile(String string) {
        if (string == null) {
            return;
        }
        this.outfile = string;
    }

    public void addMergeFile(String string) {
        if (string == null) {
            return;
        }
        this.mergefiles.addElement(string);
    }

    public void addAddFile(String string) {
        if (string == null) {
            return;
        }
        this.addfiles.addElement(string);
    }

    public void addMergeFiles(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addMergeFile(stringArray[n]);
            ++n;
        }
    }

    public void addAddFiles(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addAddFile(stringArray[n]);
            ++n;
        }
    }

    public void setCompression(boolean bl) {
        this.compression = bl;
    }

    public void link() throws Exception {
        Object object;
        Object object2;
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.outfile));
        if (this.compression) {
            zipOutputStream.setMethod(8);
            zipOutputStream.setLevel(-1);
        } else {
            zipOutputStream.setMethod(0);
        }
        Enumeration enumeration = this.mergefiles.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = new File((String)object2);
            if (((File)object).getName().endsWith(".jar") || ((File)object).getName().endsWith(".zip")) {
                this.mergeZipJarContents(zipOutputStream, (File)object);
                continue;
            }
            this.addAddFile((String)object2);
        }
        object2 = this.addfiles.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            File file = new File((String)object);
            if (file.isDirectory()) {
                this.addDirContents(zipOutputStream, file, file.getName() + '/', this.compression);
                continue;
            }
            this.addFile(zipOutputStream, file, "", this.compression);
        }
        if (zipOutputStream != null) {
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("usage: jlink output input1 ... inputN");
            System.exit(1);
        }
        jlink jlink2 = new jlink();
        jlink2.setOutfile(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            jlink2.addMergeFile(stringArray[n]);
            ++n;
        }
        try {
            jlink2.link();
        }
        catch (Exception exception) {
            System.err.print(exception.getMessage());
        }
    }

    private void mergeZipJarContents(ZipOutputStream zipOutputStream, File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            int n = string.indexOf("META-INF");
            if (n >= 0) continue;
            try {
                zipOutputStream.putNextEntry(this.processEntry(zipFile, zipEntry));
            }
            catch (ZipException zipException) {
                String string2 = zipException.getMessage();
                if (string2.indexOf("duplicate") >= 0) continue;
                throw zipException;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n2 = this.buffer.length;
            int n3 = -1;
            while ((n3 = inputStream.read(this.buffer, 0, n2)) > 0) {
                zipOutputStream.write(this.buffer, 0, n3);
            }
            inputStream.close();
            zipOutputStream.closeEntry();
        }
        zipFile.close();
    }

    private void addDirContents(ZipOutputStream zipOutputStream, File file, String string, boolean bl) throws IOException {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            File file2 = new File(file, string2);
            if (file2.isDirectory()) {
                this.addDirContents(zipOutputStream, file2, string + string2 + '/', bl);
            } else {
                this.addFile(zipOutputStream, file2, string, bl);
            }
            ++n;
        }
    }

    private String getEntryName(File file, String string) {
        String string2 = file.getName();
        if (!string2.endsWith(".class")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                String string3 = ClassNameReader.getClassName(fileInputStream);
                ((InputStream)fileInputStream).close();
                if (string3 != null) {
                    return string3.replace('.', '/') + ".class";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("From " + file.getPath() + " and prefix " + string + ", creating entry " + string + string2);
        return string + string2;
    }

    private void addFile(ZipOutputStream zipOutputStream, File file, String string, boolean bl) throws IOException {
        long l = 0L;
        if (!file.exists()) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(this.getEntryName(file, string));
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        if (!bl) {
            zipEntry.setCrc(this.calcChecksum(file));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.addToOutputStream(zipOutputStream, fileInputStream, zipEntry);
    }

    private void addToOutputStream(ZipOutputStream zipOutputStream, InputStream inputStream, ZipEntry zipEntry) throws IOException {
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (ZipException zipException) {
            inputStream.close();
            return;
        }
        int n = -1;
        while ((n = inputStream.read(this.buffer)) > 0) {
            zipOutputStream.write(this.buffer, 0, n);
        }
        zipOutputStream.closeEntry();
        inputStream.close();
    }

    private ZipEntry processEntry(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        Object object;
        String string = zipEntry.getName();
        if (!zipEntry.isDirectory() && !string.endsWith(".class")) {
            try {
                object = zipFile.getInputStream(zipFile.getEntry(string));
                String string2 = ClassNameReader.getClassName((InputStream)object);
                ((InputStream)object).close();
                if (string2 != null) {
                    string = string2.replace('.', '/') + ".class";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new ZipEntry(string);
        ((ZipEntry)object).setTime(zipEntry.getTime());
        ((ZipEntry)object).setExtra(zipEntry.getExtra());
        ((ZipEntry)object).setComment(zipEntry.getComment());
        ((ZipEntry)object).setTime(zipEntry.getTime());
        if (this.compression) {
            ((ZipEntry)object).setMethod(8);
        } else {
            ((ZipEntry)object).setMethod(0);
            ((ZipEntry)object).setCrc(zipEntry.getCrc());
            ((ZipEntry)object).setSize(zipEntry.getSize());
        }
        return object;
    }

    private long calcChecksum(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        return this.calcChecksum(bufferedInputStream, file.length());
    }

    private long calcChecksum(InputStream inputStream, long l) throws IOException {
        CRC32 cRC32 = new CRC32();
        int n = this.buffer.length;
        int n2 = -1;
        int n3 = 0;
        while ((n2 = inputStream.read(this.buffer, 0, n)) > 0) {
            n3 += n2;
            cRC32.update(this.buffer, 0, n2);
        }
        inputStream.close();
        return cRC32.getValue();
    }
}

