/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sound;

import java.io.File;
import java.util.Random;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.sound.AntSoundPlayer;

public class SoundTask
extends Task {
    private BuildAlert success = null;
    private BuildAlert fail = null;

    public BuildAlert createSuccess() {
        this.success = new BuildAlert();
        return this.success;
    }

    public BuildAlert createFail() {
        this.fail = new BuildAlert();
        return this.fail;
    }

    public void init() {
    }

    public void execute() {
        AntSoundPlayer antSoundPlayer = new AntSoundPlayer();
        if (this.success == null) {
            this.log("No nested success element found.", 1);
        } else {
            antSoundPlayer.addBuildSuccessfulSound(this.success.getSource(), this.success.getLoops(), this.success.getDuration());
        }
        if (this.fail == null) {
            this.log("No nested failure element found.", 1);
        } else {
            antSoundPlayer.addBuildFailedSound(this.fail.getSource(), this.fail.getLoops(), this.fail.getDuration());
        }
        this.getProject().addBuildListener((BuildListener)antSoundPlayer);
    }

    public class BuildAlert {
        private File source = null;
        private int loops = 0;
        private Long duration = null;

        public void setDuration(Long l) {
            this.duration = l;
        }

        public void setSource(File file) {
            this.source = file;
        }

        public void setLoops(int n) {
            this.loops = n;
        }

        public File getSource() {
            Object var1_1 = null;
            if (this.source.exists()) {
                if (this.source.isDirectory()) {
                    File[] fileArray = this.source.listFiles();
                    int n = fileArray.length;
                    Random random = new Random();
                    int n2 = random.nextInt(n);
                    this.source = fileArray[n2];
                }
            } else {
                SoundTask.this.log(this.source + ": invalid path.", 1);
                this.source = var1_1;
            }
            return this.source;
        }

        public int getLoops() {
            return this.loops;
        }

        public Long getDuration() {
            return this.duration;
        }
    }
}

