#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "prescheme.h"
#include "scheme48vm-prelude.h"
#include "scheme48vm.h"
#include "scheme48heap.h"

static void relocate_image(long, char *, char *);
static void relocate_symbol_tableB(long, long);
static void relocate_binding_tableB(long, long);
long s48_startup_procedure(void);
long s48_initial_symbols(void);
long s48_initial_imported_bindings(void);
long s48_initial_exported_bindings(void);
long s48_resumer_records(void);
void s48_set_image_valuesB(long, long, long, long, long);
void s48_initializing_gc_root(void);
void s48_initialization_completeB(void);
void s48_reverse_byte_orderB(char *, char *);
void s48_relocate_all(long, char *, char *, long, long, long);
long s48_read_image(char*, long);
static long SstatusS;
static char SeofPS;
static long Sstartup_procedureS;
static long SsymbolsS;
static long Simported_bindingsS;
static long Sexported_bindingsS;
static long Sresumer_recordsS;
static char SinitializingPS;

static void relocate_image(long delta_0X, char * start_1X, char * end_2X)
{
  char * arg1K0;
  long arg0K0;
  long d_5X;
  long descriptor_4X;
  char * ptr_3X;
 {  arg1K0 = start_1X;
  goto L1706;}
 L1706: {
  ptr_3X = arg1K0;
  if ((ptr_3X < end_2X)) {
    descriptor_4X = *((long *) ptr_3X);
    if ((3 == (3 & descriptor_4X))) {
      arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_4X))) + delta_0X))));
      goto L1711;}
    else {
      arg0K0 = descriptor_4X;
      goto L1711;}}
  else {
    return;}}
 L1711: {
  d_5X = arg0K0;
  *((long *) ptr_3X) = (long) (d_5X);
  if ((2 == (3 & d_5X))) {
    if (((31 & (((d_5X)>>2))) < 16)) {
      goto L1725;}
    else {
      arg1K0 = (ptr_3X + (4 + (-4 & (3 + ((long)(((unsigned long)d_5X)>>8))))));
      goto L1706;}}
  else {
    goto L1725;}}
 L1725: {
  arg1K0 = (ptr_3X + 4);
  goto L1706;}
}
static void relocate_symbol_tableB(long table_6X, long delta_7X)
{
  long arg0K0;
  char * addr_19X;
  long val_18X;
  long next_17X;
  long next_16X;
  long link_15X;
  long entry_14X;
  char * addr_13X;
  long value_12X;
  long bucket_11X;
  long bucket_10X;
  long link_9X;
  long i_8X;
 {  if ((3 == (3 & table_6X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_6X))) + -4))))>>2))))) {
      arg0K0 = 0;
      goto L1885;}
    else {
      return;}}
  else {
    return;}}
 L1885: {
  i_8X = arg0K0;
  if ((1024 == i_8X)) {
    return;}
  else {
    link_9X = *((long *) ((((char *) (-3 + table_6X))) + (((i_8X)<<2))));
    if ((0 == (3 & link_9X))) {
      arg0K0 = (3 + (-4 & link_9X));
      goto L1829;}
    else {
      arg0K0 = link_9X;
      goto L1829;}}}
 L1829: {
  bucket_10X = arg0K0;
  if ((1 == bucket_10X)) {
    goto L1890;}
  else {
    bucket_11X = bucket_10X + delta_7X;
    if ((3 == (3 & bucket_11X))) {
      arg0K0 = (-4 & bucket_11X);
      goto L1840;}
    else {
      arg0K0 = bucket_11X;
      goto L1840;}}}
 L1890: {
  arg0K0 = (1 + i_8X);
  goto L1885;}
 L1840: {
  value_12X = arg0K0;
  addr_13X = (((char *) (-3 + table_6X))) + (((i_8X)<<2));S48_WRITE_BARRIER(table_6X, addr_13X, value_12X);
  *((long *) addr_13X) = (long) (value_12X);
  arg0K0 = bucket_11X;
  goto L1846;}
 L1846: {
  entry_14X = arg0K0;
  link_15X = *((long *) ((((char *) (-3 + entry_14X))) + 4));
  if ((0 == (3 & link_15X))) {
    arg0K0 = (3 + (-4 & link_15X));
    goto L1850;}
  else {
    arg0K0 = link_15X;
    goto L1850;}}
 L1850: {
  next_16X = arg0K0;
  if ((1 == next_16X)) {
    goto L1890;}
  else {
    next_17X = next_16X + delta_7X;
    if ((3 == (3 & next_17X))) {
      arg0K0 = (-4 & next_17X);
      goto L1861;}
    else {
      arg0K0 = next_17X;
      goto L1861;}}}
 L1861: {
  val_18X = arg0K0;
  addr_19X = (((char *) (-3 + entry_14X))) + 4;S48_WRITE_BARRIER(entry_14X, addr_19X, val_18X);
  *((long *) addr_19X) = (long) (val_18X);
  arg0K0 = next_17X;
  goto L1846;}
}
static void relocate_binding_tableB(long table_20X, long delta_21X)
{
  long arg0K0;
  char * addr_33X;
  long val_32X;
  long next_31X;
  long next_30X;
  long link_29X;
  long entry_28X;
  char * addr_27X;
  long value_26X;
  long bucket_25X;
  long bucket_24X;
  long link_23X;
  long i_22X;
 {  if ((3 == (3 & table_20X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_20X))) + -4))))>>2))))) {
      arg0K0 = 0;
      goto L2087;}
    else {
      return;}}
  else {
    return;}}
 L2087: {
  i_22X = arg0K0;
  if ((1024 == i_22X)) {
    return;}
  else {
    link_23X = *((long *) ((((char *) (-3 + table_20X))) + (((i_22X)<<2))));
    if ((0 == (3 & link_23X))) {
      arg0K0 = (3 + (-4 & link_23X));
      goto L2031;}
    else {
      arg0K0 = link_23X;
      goto L2031;}}}
 L2031: {
  bucket_24X = arg0K0;
  if ((1 == bucket_24X)) {
    goto L2092;}
  else {
    bucket_25X = bucket_24X + delta_21X;
    if ((3 == (3 & bucket_25X))) {
      arg0K0 = (-4 & bucket_25X);
      goto L2042;}
    else {
      arg0K0 = bucket_25X;
      goto L2042;}}}
 L2092: {
  arg0K0 = (1 + i_22X);
  goto L2087;}
 L2042: {
  value_26X = arg0K0;
  addr_27X = (((char *) (-3 + table_20X))) + (((i_22X)<<2));S48_WRITE_BARRIER(table_20X, addr_27X, value_26X);
  *((long *) addr_27X) = (long) (value_26X);
  arg0K0 = bucket_25X;
  goto L2048;}
 L2048: {
  entry_28X = arg0K0;
  link_29X = *((long *) ((((char *) (-3 + entry_28X))) + 12));
  if ((0 == (3 & link_29X))) {
    arg0K0 = (3 + (-4 & link_29X));
    goto L2052;}
  else {
    arg0K0 = link_29X;
    goto L2052;}}
 L2052: {
  next_30X = arg0K0;
  if ((1 == next_30X)) {
    goto L2092;}
  else {
    next_31X = next_30X + delta_21X;
    if ((3 == (3 & next_31X))) {
      arg0K0 = (-4 & next_31X);
      goto L2063;}
    else {
      arg0K0 = next_31X;
      goto L2063;}}}
 L2063: {
  val_32X = arg0K0;
  addr_33X = (((char *) (-3 + entry_28X))) + 12;S48_WRITE_BARRIER(entry_28X, addr_33X, val_32X);
  *((long *) addr_33X) = (long) (val_32X);
  arg0K0 = next_31X;
  goto L2048;}
}
long s48_startup_procedure(void)
{

 {  return (Sstartup_procedureS);}
}
long s48_initial_symbols(void)
{

 {  return (SsymbolsS);}
}
long s48_initial_imported_bindings(void)
{

 {  return (Simported_bindingsS);}
}
long s48_initial_exported_bindings(void)
{

 {  return (Sexported_bindingsS);}
}
long s48_resumer_records(void)
{

 {  return (Sresumer_recordsS);}
}
void s48_set_image_valuesB(long startup_proc_34X, long symbols_35X, long imports_36X, long exports_37X, long records_38X)
{

 {  Sstartup_procedureS = startup_proc_34X;
  SsymbolsS = symbols_35X;
  Simported_bindingsS = imports_36X;
  Sexported_bindingsS = exports_37X;
  Sresumer_recordsS = records_38X;
  return;}
}
void s48_initializing_gc_root(void)
{
  long v_43X;
  long v_42X;
  long v_41X;
  long v_40X;
  long v_39X;
 {  if ((SinitializingPS)) {
    v_39X = s48_trace_value((Sstartup_procedureS));
    Sstartup_procedureS = v_39X;
    v_40X = s48_trace_value((SsymbolsS));
    SsymbolsS = v_40X;
    v_41X = s48_trace_value((Simported_bindingsS));
    Simported_bindingsS = v_41X;
    v_42X = s48_trace_value((Sexported_bindingsS));
    Sexported_bindingsS = v_42X;
    v_43X = s48_trace_value((Sresumer_recordsS));
    Sresumer_recordsS = v_43X;
    return;}
  else {
    return;}}
}
void s48_initialization_completeB(void)
{

 {  SinitializingPS = 0;
  return;}
}
void s48_reverse_byte_orderB(char * start_44X, char * end_45X)
{
  char * arg1K0;
  char * next_50X;
  long value_49X;
  long x_48X;
  long x_47X;
  char * ptr_46X;
 {  ps_write_string("Correcting byte order of resumed image.", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  arg1K0 = start_44X;
  goto L1607;}
 L1607: {
  ptr_46X = arg1K0;
  if ((ptr_46X < end_45X)) {
    x_47X = *((unsigned char *) ptr_46X);
    *((unsigned char *) ptr_46X) = (unsigned char) ((*((unsigned char *) (ptr_46X + 3))));
    *((unsigned char *) (ptr_46X + 3)) = (unsigned char) (x_47X);
    x_48X = *((unsigned char *) (ptr_46X + 1));
    *((unsigned char *) (ptr_46X + 1)) = (unsigned char) ((*((unsigned char *) (ptr_46X + 2))));
    *((unsigned char *) (ptr_46X + 2)) = (unsigned char) (x_48X);
    value_49X = *((long *) ptr_46X);
    next_50X = ptr_46X + 4;
    if ((2 == (3 & value_49X))) {
      if (((31 & (((value_49X)>>2))) < 16)) {
        arg1K0 = next_50X;
        goto L1607;}
      else {
        arg1K0 = (next_50X + (-4 & (3 + ((long)(((unsigned long)value_49X)>>8)))));
        goto L1607;}}
    else {
      arg1K0 = next_50X;
      goto L1607;}}
  else {
    return;}}
}
void s48_relocate_all(long delta_51X, char * new_begin_52X, char * new_hp_53X, long symbols_54X, long imported_55X, long exported_56X)
{

 {relocate_symbol_tableB(symbols_54X, delta_51X);relocate_binding_tableB(imported_55X, delta_51X);relocate_binding_tableB(exported_56X, delta_51X);
  relocate_image(delta_51X, new_begin_52X, new_hp_53X);
  return;}
}
long s48_read_image(char *filename_57X, long heap_size_58X)
{
  char * arg1K3;
  char * arg1K2;
  char * arg1K1;
  FILE * arg4K0;
  char *arg3K1;
  char arg2K1;
  char arg2K4;
  char arg2K0;
  long arg0K2;
  long arg0K1;
  long arg0K0;
  long v_162X;
  long descriptor_161X;
  long v_160X;
  long descriptor_159X;
  long v_158X;
  long descriptor_157X;
  long v_156X;
  long status_155X;
  long status_154X;
  long status_153X;
  long status_152X;
  long descriptor_151X;
  long v_150X;
  long descriptor_149X;
  long status_148X;
  long status_147X;
  char eofP_146X;
  char v_145X;
  char *string_144X;
  char okayP_143X;
  long status_142X;
  long status_141X;
  long status_140X;
  char eofP_139X;
  long got_138X;
  long need_137X;
  char * new_hp_136X;
  long delta_135X;
  char reverseP_134X;
  char * old_hp_133X;
  char * old_begin_132X;
  char * new_begin_131X;
  FILE * port_130X;
  long status_129X;
  char eofP_128X;
  long status_127X;
  long status_126X;
  long status_125X;
  long x_124X;
  long x_123X;
  char *string_122X;
  char okayP_121X;
  long status_120X;
  long status_119X;
  char eofP_118X;
  char ch_117X;
  long status_116X;
  char eofP_115X;
  long got_114X;
  char * new_begin_113X;
  long v_112X;
  long status_111X;
  char eofP_110X;
  long thing_109X;
  long v_108X;
  long status_107X;
  char eofP_106X;
  long thing_105X;
  long v_104X;
  long status_103X;
  char eofP_102X;
  long thing_101X;
  long v_100X;
  long status_99X;
  char eofP_98X;
  long thing_97X;
  long v_96X;
  long status_95X;
  char eofP_94X;
  long thing_93X;
  char * old_hp_92X;
  long cells_91X;
  long status_90X;
  char eofP_89X;
  long thing_88X;
  char * old_begin_87X;
  long cells_86X;
  long status_85X;
  char eofP_84X;
  char thing_83X;
  long status_82X;
  char eofP_81X;
  long thing_80X;
  long old_bytes_per_cell_79X;
  long status_78X;
  char eofP_77X;
  long status_76X;
  char eofP_75X;
  char ch_74X;
  long i_73X;
  long status_72X;
  char eofP_71X;
  long thing_70X;
  char same_versionP_69X;
  long status_68X;
  char eofP_67X;
  long status_66X;
  char eofP_65X;
  char ch_64X;
  long status_63X;
  char eofP_62X;
  char ch_61X;
  long status_60X;
  FILE * port_59X;
 {  port_59X = ps_open_input_file(filename_57X, &status_60X);
  if ((status_60X == NO_ERRORS)) {
    SstatusS = NO_ERRORS;
    SeofPS = 0;
    if ((SeofPS)) {
      goto L2786;}
    else {
      goto L3525;}}
  else {
    ps_write_string("Can't open heap image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    ps_write_string((ps_error_string(status_60X)), (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2786: {
  if ((SeofPS)) {
    goto L2819;}
  else {
    goto L3489;}}
 L3525: {
  PS_READ_CHAR(port_59X, ch_61X, eofP_62X, status_63X)
  if (eofP_62X) {
    arg2K0 = eofP_62X;
    arg0K1 = status_63X;
    goto L2764;}
  else {
    if ((status_63X == NO_ERRORS)) {
      if ((12 == ch_61X)) {
        arg2K0 = 0;
        arg0K1 = status_63X;
        goto L2764;}
      else {
        goto L3525;}}
    else {
      arg2K0 = eofP_62X;
      arg0K1 = status_63X;
      goto L2764;}}}
 L2819: {
  if ((SeofPS)) {
    arg2K0 = 0;
    goto L2852;}
  else {
    arg0K0 = 0;
    goto L3465;}}
 L3489: {
  PS_READ_CHAR(port_59X, ch_64X, eofP_65X, status_66X)
  if (eofP_65X) {
    arg2K0 = eofP_65X;
    arg0K1 = status_66X;
    goto L2797;}
  else {
    if ((status_66X == NO_ERRORS)) {
      if ((10 == ch_64X)) {
        arg2K0 = 0;
        arg0K1 = status_66X;
        goto L2797;}
      else {
        goto L3489;}}
    else {
      arg2K0 = eofP_65X;
      arg0K1 = status_66X;
      goto L2797;}}}
 L2764: {
  eofP_67X = arg2K0;
  status_68X = arg0K1;
  if (eofP_67X) {
    SeofPS = 1;
    goto L2786;}
  else {
    if (((SstatusS) == NO_ERRORS)) {
      goto L2786;}
    else {
      SeofPS = 1;
      SstatusS = status_68X;
      goto L2786;}}}
 L2852: {
  same_versionP_69X = arg2K0;
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L2887;}
  else {
    PS_READ_INTEGER(port_59X, thing_70X, eofP_71X, status_72X)
    if (eofP_71X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L2887;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_70X;
        goto L2887;}
      else {
        SeofPS = 1;
        SstatusS = status_72X;
        arg0K0 = -1;
        goto L2887;}}}}
 L3465: {
  i_73X = arg0K0;
  PS_READ_CHAR(port_59X, ch_74X, eofP_75X, status_76X)
  if (eofP_75X) {
    arg2K0 = 0;
    arg2K1 = eofP_75X;
    arg0K2 = status_76X;
    goto L2830;}
  else {
    if ((status_76X == NO_ERRORS)) {
      if ((i_73X == (strlen((char *) "Vanilla 32")))) {
        arg2K0 = (10 == ch_74X);
        arg2K1 = 0;
        arg0K2 = status_76X;
        goto L2830;}
      else {
        if ((ch_74X == (*("Vanilla 32" + i_73X)))) {
          arg0K0 = (1 + i_73X);
          goto L3465;}
        else {
          arg2K0 = 0;
          arg2K1 = 0;
          arg0K2 = status_76X;
          goto L2830;}}}
    else {
      arg2K0 = 0;
      arg2K1 = eofP_75X;
      arg0K2 = status_76X;
      goto L2830;}}}
 L2797: {
  eofP_77X = arg2K0;
  status_78X = arg0K1;
  if (eofP_77X) {
    SeofPS = 1;
    goto L2819;}
  else {
    if (((SstatusS) == NO_ERRORS)) {
      goto L2819;}
    else {
      SeofPS = 1;
      SstatusS = status_78X;
      goto L2819;}}}
 L2887: {
  old_bytes_per_cell_79X = arg0K0;
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L2922;}
  else {
    PS_READ_INTEGER(port_59X, thing_80X, eofP_81X, status_82X)
    if (eofP_81X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L2922;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_80X;
        goto L2922;}
      else {
        SeofPS = 1;
        SstatusS = status_82X;
        arg0K0 = -1;
        goto L2922;}}}}
 L2830: {
  thing_83X = arg2K0;
  eofP_84X = arg2K1;
  status_85X = arg0K2;
  if (eofP_84X) {
    SeofPS = 1;
    arg2K0 = 0;
    goto L2852;}
  else {
    if (((SstatusS) == NO_ERRORS)) {
      arg2K0 = thing_83X;
      goto L2852;}
    else {
      SeofPS = 1;
      SstatusS = status_85X;
      arg2K0 = 0;
      goto L2852;}}}
 L2922: {
  cells_86X = arg0K0;
  old_begin_87X = ((char *) (((cells_86X)<<2)));
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L2959;}
  else {
    PS_READ_INTEGER(port_59X, thing_88X, eofP_89X, status_90X)
    if (eofP_89X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L2959;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_88X;
        goto L2959;}
      else {
        SeofPS = 1;
        SstatusS = status_90X;
        arg0K0 = -1;
        goto L2959;}}}}
 L2959: {
  cells_91X = arg0K0;
  old_hp_92X = ((char *) (((cells_91X)<<2)));
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L2996;}
  else {
    PS_READ_INTEGER(port_59X, thing_93X, eofP_94X, status_95X)
    if (eofP_94X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L2996;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_93X;
        goto L2996;}
      else {
        SeofPS = 1;
        SstatusS = status_95X;
        arg0K0 = -1;
        goto L2996;}}}}
 L2996: {
  v_96X = arg0K0;
  SsymbolsS = v_96X;
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L3032;}
  else {
    PS_READ_INTEGER(port_59X, thing_97X, eofP_98X, status_99X)
    if (eofP_98X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L3032;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_97X;
        goto L3032;}
      else {
        SeofPS = 1;
        SstatusS = status_99X;
        arg0K0 = -1;
        goto L3032;}}}}
 L3032: {
  v_100X = arg0K0;
  Simported_bindingsS = v_100X;
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L3068;}
  else {
    PS_READ_INTEGER(port_59X, thing_101X, eofP_102X, status_103X)
    if (eofP_102X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L3068;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_101X;
        goto L3068;}
      else {
        SeofPS = 1;
        SstatusS = status_103X;
        arg0K0 = -1;
        goto L3068;}}}}
 L3068: {
  v_104X = arg0K0;
  Sexported_bindingsS = v_104X;
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L3104;}
  else {
    PS_READ_INTEGER(port_59X, thing_105X, eofP_106X, status_107X)
    if (eofP_106X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L3104;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_105X;
        goto L3104;}
      else {
        SeofPS = 1;
        SstatusS = status_107X;
        arg0K0 = -1;
        goto L3104;}}}}
 L3104: {
  v_108X = arg0K0;
  Sresumer_recordsS = v_108X;
  if ((SeofPS)) {
    arg0K0 = -1;
    goto L3140;}
  else {
    PS_READ_INTEGER(port_59X, thing_109X, eofP_110X, status_111X)
    if (eofP_110X) {
      SeofPS = 1;
      arg0K0 = -1;
      goto L3140;}
    else {
      if (((SstatusS) == NO_ERRORS)) {
        arg0K0 = thing_109X;
        goto L3140;}
      else {
        SeofPS = 1;
        SstatusS = status_111X;
        arg0K0 = -1;
        goto L3140;}}}}
 L3140: {
  v_112X = arg0K0;
  Sstartup_procedureS = v_112X;
  if ((SeofPS)) {
    goto L3176;}
  else {
    goto L3396;}}
 L3176: {
  if (((SstatusS) == NO_ERRORS)) {
    if ((SeofPS)) {
      SstatusS = EDOM;
      ps_write_string("Premature EOF when reading image file", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      if (((SstatusS) == NO_ERRORS)) {
        goto L3265;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L3265;}}
    else {
      if (same_versionP_69X) {
        if ((4 == old_bytes_per_cell_79X)) {
          new_begin_113X = s48_initialize_heap(heap_size_58X, ((((3 + (old_hp_92X - old_begin_87X)))>>2)), old_begin_87X);
          got_114X = ps_read_block(port_59X, ((char *) new_begin_113X), 4, &eofP_115X, &status_116X);
          if ((status_116X == NO_ERRORS)) {
            if (eofP_115X) {
              arg2K0 = 0;
              arg3K1 = "Premature EOF when reading image file";
              goto L2598;}
            else {
              if ((got_114X < 4)) {
                arg2K0 = 0;
                arg3K1 = "Read returned too few bytes";
                goto L2598;}
              else {
                arg2K0 = 1;
                arg3K1 = "";
                goto L2598;}}}
          else {
            SstatusS = status_116X;
            arg2K0 = 0;
            arg3K1 = "Error reading from image file";
            goto L2598;}}
        else {
          ps_write_string("Incompatible bytes-per-cell in image", (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          if (((SstatusS) == NO_ERRORS)) {
            goto L3325;}
          else {
            ps_write_string((ps_error_string((SstatusS))), (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            goto L3325;}}}
      else {
        ps_write_string("Format of image is incompatible with this version of system", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        if (((SstatusS) == NO_ERRORS)) {
          goto L3295;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L3295;}}}}
  else {
    ps_write_string("Error reading from image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    if (((SstatusS) == NO_ERRORS)) {
      goto L3240;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L3240;}}}
 L3396: {
  PS_READ_CHAR(port_59X, ch_117X, eofP_118X, status_119X)
  if (eofP_118X) {
    arg2K0 = eofP_118X;
    arg0K1 = status_119X;
    goto L3154;}
  else {
    if ((status_119X == NO_ERRORS)) {
      if ((12 == ch_117X)) {
        arg2K0 = 0;
        arg0K1 = status_119X;
        goto L3154;}
      else {
        goto L3396;}}
    else {
      arg2K0 = eofP_118X;
      arg0K1 = status_119X;
      goto L3154;}}}
 L3265: {
  status_120X = ps_close(port_59X);
  if ((status_120X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2598: {
  okayP_121X = arg2K0;
  string_122X = arg3K1;
  if (okayP_121X) {
    if ((1 == (*((long *) new_begin_113X)))) {
      arg4K0 = port_59X;
      arg1K1 = new_begin_113X;
      arg1K2 = old_begin_87X;
      arg1K3 = old_hp_92X;
      arg2K4 = 0;
      goto L2228;}
    else {
      x_123X = *((unsigned char *) new_begin_113X);
      *((unsigned char *) new_begin_113X) = (unsigned char) ((*((unsigned char *) (new_begin_113X + 3))));
      *((unsigned char *) (new_begin_113X + 3)) = (unsigned char) (x_123X);
      x_124X = *((unsigned char *) (new_begin_113X + 1));
      *((unsigned char *) (new_begin_113X + 1)) = (unsigned char) ((*((unsigned char *) (new_begin_113X + 2))));
      *((unsigned char *) (new_begin_113X + 2)) = (unsigned char) (x_124X);
      if ((1 == (*((long *) new_begin_113X)))) {
        arg4K0 = port_59X;
        arg1K1 = new_begin_113X;
        arg1K2 = old_begin_87X;
        arg1K3 = old_hp_92X;
        arg2K4 = 1;
        goto L2228;}
      else {
        ps_write_string("Unable to correct byte order", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        if (((SstatusS) == NO_ERRORS)) {
          goto L2695;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L2695;}}}}
  else {
    ps_write_string(string_122X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    if (((SstatusS) == NO_ERRORS)) {
      goto L2649;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L2649;}}}
 L3325: {
  status_125X = ps_close(port_59X);
  if ((status_125X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L3295: {
  status_126X = ps_close(port_59X);
  if ((status_126X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L3240: {
  status_127X = ps_close(port_59X);
  if ((status_127X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L3154: {
  eofP_128X = arg2K0;
  status_129X = arg0K1;
  if (eofP_128X) {
    SeofPS = 1;
    goto L3176;}
  else {
    if (((SstatusS) == NO_ERRORS)) {
      goto L3176;}
    else {
      SeofPS = 1;
      SstatusS = status_129X;
      goto L3176;}}}
 L2228: {
  port_130X = arg4K0;
  new_begin_131X = arg1K1;
  old_begin_132X = arg1K2;
  old_hp_133X = arg1K3;
  reverseP_134X = arg2K4;
  delta_135X = new_begin_131X - old_begin_132X;
  new_hp_136X = old_hp_133X + delta_135X;
  need_137X = old_hp_133X - old_begin_132X;
  got_138X = ps_read_block(port_130X, ((char *) new_begin_131X), need_137X, &eofP_139X, &status_140X);
  if ((status_140X == NO_ERRORS)) {
    if (eofP_139X) {
      arg2K0 = 0;
      arg3K1 = "Premature EOF when reading image file";
      goto L2236;}
    else {
      if ((got_138X < need_137X)) {
        arg2K0 = 0;
        arg3K1 = "Read returned too few bytes";
        goto L2236;}
      else {
        arg2K0 = 1;
        arg3K1 = "";
        goto L2236;}}}
  else {
    SstatusS = status_140X;
    arg2K0 = 0;
    arg3K1 = "Error reading from image file";
    goto L2236;}}
 L2695: {
  status_141X = ps_close(port_59X);
  if ((status_141X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2649: {
  status_142X = ps_close(port_59X);
  if ((status_142X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2236: {
  okayP_143X = arg2K0;
  string_144X = arg3K1;
  PS_READ_CHAR(port_130X, v_145X, eofP_146X, status_147X)
  if (okayP_143X) {
    if ((status_147X == NO_ERRORS)) {
      if (eofP_146X) {
        status_148X = ps_close(port_130X);
        if ((status_148X == NO_ERRORS)) {
          descriptor_149X = Sstartup_procedureS;
          if ((3 == (3 & descriptor_149X))) {
            arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_149X))) + delta_135X))));
            goto L2268;}
          else {
            arg0K0 = descriptor_149X;
            goto L2268;}}
        else {
          ps_write_string("Error closing image file", (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          if (((SstatusS) == NO_ERRORS)) {
            goto L2435;}
          else {
            ps_write_string((ps_error_string((SstatusS))), (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            goto L2435;}}}
      else {
        ps_write_string("Image file has extraneous data after image", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        if (((SstatusS) == NO_ERRORS)) {
          goto L2405;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L2405;}}}
    else {
      ps_write_string("Error reading from image file", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      if (((SstatusS) == NO_ERRORS)) {
        goto L2375;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L2375;}}}
  else {
    ps_write_string(string_144X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    if (((SstatusS) == NO_ERRORS)) {
      goto L2345;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L2345;}}}
 L2268: {
  v_150X = arg0K0;
  Sstartup_procedureS = v_150X;
  descriptor_151X = SsymbolsS;
  if ((3 == (3 & descriptor_151X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_151X))) + delta_135X))));
    goto L2273;}
  else {
    arg0K0 = descriptor_151X;
    goto L2273;}}
 L2435: {
  status_152X = ps_close(port_130X);
  if ((status_152X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2405: {
  status_153X = ps_close(port_130X);
  if ((status_153X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2375: {
  status_154X = ps_close(port_130X);
  if ((status_154X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2345: {
  status_155X = ps_close(port_130X);
  if ((status_155X == NO_ERRORS)) {
    return -1;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L2273: {
  v_156X = arg0K0;
  SsymbolsS = v_156X;
  descriptor_157X = Simported_bindingsS;
  if ((3 == (3 & descriptor_157X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_157X))) + delta_135X))));
    goto L2278;}
  else {
    arg0K0 = descriptor_157X;
    goto L2278;}}
 L2278: {
  v_158X = arg0K0;
  Simported_bindingsS = v_158X;
  descriptor_159X = Sexported_bindingsS;
  if ((3 == (3 & descriptor_159X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_159X))) + delta_135X))));
    goto L2283;}
  else {
    arg0K0 = descriptor_159X;
    goto L2283;}}
 L2283: {
  v_160X = arg0K0;
  Sexported_bindingsS = v_160X;
  descriptor_161X = Sresumer_recordsS;
  if ((3 == (3 & descriptor_161X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_161X))) + delta_135X))));
    goto L2288;}
  else {
    arg0K0 = descriptor_161X;
    goto L2288;}}
 L2288: {
  v_162X = arg0K0;
  Sresumer_recordsS = v_162X;
  if (reverseP_134X) {s48_reverse_byte_orderB(new_begin_131X, new_hp_136X);
    goto L2299;}
  else {
    goto L2299;}}
 L2299: {
  if ((0 == delta_135X)) {
    return 0;}
  else {relocate_symbol_tableB((SsymbolsS), delta_135X);relocate_binding_tableB((Simported_bindingsS), delta_135X);relocate_binding_tableB((Sexported_bindingsS), delta_135X);relocate_image(delta_135X, new_begin_131X, new_hp_136X);
    return 0;}}
}void
s48_read_image_init(void)
{
SstatusS = NO_ERRORS;
SeofPS = 0;
SinitializingPS = 1;
}
