function rec=loadplots(fil)
//Given a file generated by xsave of by the save menu in graphic window
//this function returns a data structure containing the plot definition
//
// rec is a typed list with type "SPLOT" each of the 2:n fiels  contains
// a graphic instruction definition and parameters
// for example if a user saves the graphics generated by xbasc();plot2d()
//in the file foo.scg
//  rec=loadplots('foo.scg') is a data structure such that rec(9) defines
//  the plot2d parameters. rec(9)(1) gives the structure field names
//
// For simple cases txt=string(rec) generates the Scilab instruction
// which reproduce the plot. To make the necessary functions known load
// the loadplots function first for exmaple with the instruction 
//loadplots;
//
// Copyright INRIA
// Author: Serge Steer  
 
  ufil=mopen(fil,'rb')
  rec=tlist('SPLOT')
  pos=mtell(ufil)
  n1=mget(1,'uib',ufil)
  if n1<>8 then mclose(ufil),error('Given file is not an old graphic one');end
  mseek(pos,ufil,'set')
  SciF_version=LoadVectC()
  if part(SciF_version,1:4)<>"SciG" then mclose(ufil),error('Given file is not an old graphic one'),end
  while %t do
    typ=LoadVectC();//disp(typ)
    if typ=='endplots' then break,end
    rec($+1)=LoadTPlot(typ);
  end
  mclose(ufil)
endfunction

function rec=LoadTPlot(typ)
// Copyright INRIA
// Author: Serge Steer

  // The table here is translated from routines/graphics/RecLoad.c
  table=["axis","LoadSciAxis"
	 "champ","LoadChamp"
	 "colormap","LoadColormap"
	 "contour","LoadContour"
	 "contour2","LoadContour2D"
	 "fac3d","LoadFac3D"
	 "fac3d1","LoadFac3D"
	 "fac3d2","LoadFac3D"
	 "fac3d3","LoadFac3D"
	 "fec_n","LoadFec_n"
	 "fec","LoadFec"
	 "gray","LoadGray"
	 "gray1","LoadGray1"
	 "gray2","LoadGray2"
	 "nscale","LoadNEch"
	 "param3d","LoadParam3D"
	 "param3d1","LoadParam3D1"
	 "plot2d","LoadPlot"
	 "plot3d","LoadPlot3D"
	 "plot3d1","LoadPlot3D"
	 "scale","LoadEch"
	 "xcall1","LoadXcall1"
	 "xgrid","LoadGrid"]
  k=find(typ==table(:,1))
  if k==[] then
    error('LoadTPlot, unknown key '+typ)
  else
    execstr('rec='+table(k,2)+'()')
  end
endfunction

function rec=LoadXcall1()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c

  rec=xcall1_rec()
  rec.fname=LoadVectC()
  rec.string=LoadVectC()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.n3=LoadLI()
  rec.n4=LoadLI()
  rec.n5=LoadLI()
  rec.n6=LoadLI()
  rec.ndx1=LoadLI()
  rec.ndx2=LoadLI()
  rec.ndx3=LoadLI()
  rec.ndx4=LoadLI()
  rec.x1=LoadVectLI()
  rec.x2=LoadVectLI()
  rec.x3=LoadVectLI()
  rec.x4=LoadVectLI()
  rec.x5=LoadVectLI()
  rec.x6=LoadVectLI()
  rec.dx1=LoadVectF()
  rec.dx2=LoadVectF()
  rec.dx3=LoadVectF()
  rec.dx4=LoadVectF()
  if rec.fname=='xstringa' then
    // in fact xtitle 
    str=rec.string
    rec=xtitle_rec()
    rec.strs=[str,"",""]
    for k=1:2
      pos=mtell(ufil)
      fname=LoadVectC()
      if fname<>'xcall1' then
	mseek(pos,ufil,'set')
	return
      else
	fname=LoadVectC()
	if fname<>'xstringa' then
	  mseek(pos,ufil,'set')
	  return
	end
	rec.strs(k+1)=LoadVectC()
	for i=1:10,LoadLI(),end
	for i=1:6,LoadVectLI(),end
	for i=1:4,LoadVectF(),end
      end
    end
  end
endfunction

function rec=LoadEch()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=scale_rec()
  rec.logflag=LoadC()
  rec.name=LoadVectC()
  rec.Wrect=LoadVectF()
  rec.Frect=LoadVectF()
  rec.Frect_kp=LoadVectF()
endfunction

function rec=LoadNEch()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=nscale_rec()
  rec.logflag=LoadC()
  rec.name=LoadVectC()
  rec.flag=LoadVectC()
  rec.Wrect=LoadVectF()
  rec.Frect=LoadVectF()
  rec.Arect=LoadVectF()
  rec.Frect_kp=LoadVectF()
endfunction
function rec=LoadColormap()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=colormap_rec()
  nc=LoadLI()
  rec.cmap=matrix(mget(3*nc,'db',ufil),-1,3)
endfunction
 
function rec=LoadPlot()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=plot2d_rec();
  rec.n1=LoadLI();
  rec.n2=LoadLI();
  rec.name=LoadVectC();
  rec.xf=LoadVectC();
  if part(rec.xf,1)=='g' then 
    nx=rec.n1*rec.n2,
  elseif  part(rec.xf,1)=='o' then 
    nx=rec.n2
  else
    nx=0
  end
  if nx<>0 then
    rec.x=LoadVectF();
  else
    rec.x=[]
  end
  rec.y=LoadVectF();
  rec.style=LoadVectLI()
  rec.strflag=LoadVectC()
  rec.strflag_kp=LoadVectC()
  rec.legend=LoadVectC()

  rec.brect=LoadVectF()
  rec.brect_kp=LoadVectF()
  rec.aint=LoadVectLI()
  rec.aint_kp=LoadVectLI()
endfunction

function rec=LoadSciAxis()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=sciaxis_rec()
  typ=LoadC()
  rec.nx=LoadLI()
  rec.ny=LoadLI()
  rec.sub_int=LoadLI()
  rec.fontsize=LoadLI()
  rec.textcolor=LoadLI()
  rec.ticscolor=LoadLI()
  rec.seg=LoadLI()
  rec.f_l=LoadLI()
  rec.name=LoadVectC()
  if rec.f_l==1 then
    rec.format_n=LoadVectC()
  else
    rec.format_n=''
  end
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.str=LoadVectS()
  rec.dir=part(typ,1)
  rec.tics=part(typ,2)
  rec.logflag=part(typ,3)
endfunction

function rec=LoadGrid()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=xgrid_rec()
  rec.style=LoadLI()
  rec.name=LoadVectC()
endfunction

function rec=LoadParam3D()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=param3d_rec()
  rec.n=LoadLI()
  rec.teta=LoadD()
  rec.alpha=LoadD()
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.legend=LoadVectC()
  rec.flag=LoadVectLI()
  rec.bbox=LoadVectF()
endfunction

function rec=LoadParam3D1()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=param3d1_rec()
  rec.m=LoadLI()
  rec.n=LoadLI()
  rec.iflag=LoadLI()
  if rec.iflag==1 then
    rec.colors=LoadVectLI()
  else
    rec.colors=[]
  end
  rec.teta=LoadD()
  rec.alpha=LoadD()
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.legend=LoadVectC()
  rec.flag=LoadVectLI()
  rec.bbox=LoadVectF()
endfunction

function rec=LoadPlot3D()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=plot3d_rec()
  rec.p=LoadLI()
  rec.q=LoadLI()
  rec.teta=LoadD()
  rec.alpha=LoadD()
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.legend=LoadVectC()
  rec.flag=LoadVectLI()
  rec.bbox=LoadVectF()
endfunction

function rec=LoadFac3D()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=fac3d_rec()
  rec.p=LoadLI()
  rec.q=LoadLI()
  rec.teta=LoadD()
  rec.alpha=LoadD()
  rec.name=LoadVectC()
  if rec.name=='fac3d2'|  rec.name=='fac3d2' then
    rec.cvect=LoadVectLI()
  else
    rec.cvect=[]
  end

  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.legend=LoadVectC()
  rec.flag=LoadVectLI()
  rec.bbox=LoadVectF()
endfunction


function rec=LoadFec()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=fec_rec();
  rec.Nnode=LoadLI();;
  rec.Ntr=LoadLI();
  rec.name=LoadVectC();
  rec.x=LoadVectF();
  rec.y=LoadVectF();
  rec.triangles=LoadVectF();
  rec.func=LoadVectF();
  rec.brect=LoadVectF();
  rec.brect_kp=LoadVectF();
  rec.aaint=LoadVectLI();
  rec.aaint_kp=LoadVectLI();
  rec.strflag=LoadVectC();
  rec.strflag_kp=LoadVectC();
  rec.legend=LoadVectC();
  rec.zminmax=[LoadD(),LoadD()];
  rec.colminmax=[LoadLI(),LoadLI()];
endfunction

function rec=LoadFec_n()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=fec_rec();
  rec.Nnode=LoadLI();;
  rec.Ntr=LoadLI();
  rec.name=LoadVectC();
  rec.x=LoadVectF();
  rec.y=LoadVectF();
  rec.triangles=LoadVectF();
  rec.func=LoadVectF();
  rec.brect=LoadVectF();
  rec.brect_kp=LoadVectF();
  rec.zminmax=LoadVectF();
  rec.colminmax=LoadVectLI();
  rec.aaint=LoadVectLI();
  rec.aaint_kp=LoadVectLI();
  rec.strflag=LoadVectC();
  rec.strflag_kp=LoadVectC();
  rec.legend=LoadVectC();
endfunction

function rec=LoadContour()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=contour_rec()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.nz=LoadLI()
  rec.flagnz=LoadLI()
  if rec.flagnz<>0 then
    rec.zz=LoadVectF()
  else
    rec.zz=[]
  end
  rec.teta=LoadD()
  rec.alpha=LoadD()
  rec.zlev=LoadD()
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.legend=LoadVectC()
  rec.flag=LoadVectLI()
  rec.bbox=LoadVectF()
endfunction

function rec=LoadContour2D()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=contour2d_rec()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.nz=LoadLI()
  rec.flagnz=LoadLI()
  if rec.flagnz<>0 then
    rec.zz=LoadVectF()
  else
    rec.zz=[]
  end
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.style=LoadVectLI()
  rec.strflag=LoadVectC()
  rec.strflag_kp=LoadVectC()
  rec.legend=LoadVectC()
  rec.brect=LoadVectF()
  rec.brect_kp=LoadVectF()
  rec.aint=LoadVectLI()
  rec.aint_kp=LoadVectLI()
endfunction

function rec= LoadGray()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=gray_rec()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.z=LoadVectF()
  rec.strflag=LoadVectC()
  rec.strflag_kp=LoadVectC()
  rec.brect=LoadVectF()
  rec.brect_kp=LoadVectF()
  rec.aint=LoadVectLI()
  rec.aint_kp=LoadVectLI()
endfunction

function rec= LoadGray1()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=gray_rec()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.name=LoadVectC()
  rec.z=LoadVectF()
  rec.strflag=LoadVectC()
  rec.strflag_kp=LoadVectC()
  rec.brect=LoadVectF()
  rec.brect_kp=LoadVectF()
  rec.aint=LoadVectLI()
  rec.aint_kp=LoadVectLI()
endfunction

function rec= LoadGray2()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=gray_rec_2()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.name=LoadVectC()
  rec.z=LoadVectF()
  rec.xrect=LoadVectF()
endfunction
function rec=LoadChamp()
// Copyright INRIA
// Author: Serge Steer

// The structure definition is translated from routines/graphics/RecLoad.c
  
  rec=champ_rec()
  rec.n1=LoadLI()
  rec.n2=LoadLI()
  rec.arfact=LoadD()
  rec.name=LoadVectC()
  rec.x=LoadVectF()
  rec.y=LoadVectF()
  rec.fx=LoadVectF()
  rec.fy=LoadVectF()
  rec.strflag=LoadVectC()
  rec.strflag_kp=LoadVectC()
  rec.vrect=LoadVectF()
  rec.vrect_kp=LoadVectF()
endfunction

function n=LoadLI()
// Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c

  n=mget(1,'ib',ufil)
endfunction

function str=LoadVectC()
// Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c
  
  n1=mget(1,'uib',ufil)
  //q=int(n1/4);r=n1-4*q
  n=n1
  if modulo(n1,4)<>0 then n=4*(int(n1/4)+1),end
  c=mget(n,'uc',ufil)
  if n1-1>size(c) then pause,end
  str=ascii(c(1:n1-1))
endfunction

function x=LoadVectF()
// Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c
  
  n=mget(1,'uib',ufil)
  x=mget(n,'db',ufil)
endfunction

function i=LoadVectLI()
// Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c
  
  n=mget(1,'uib',ufil)
  i=mget(n,'ib',ufil)
endfunction

function x=LoadD()
 // Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c
 
  x=mget(1,'db',ufil)
endfunction

function x=LoadC()
// Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c
 
  n1=mget(1,'uib',ufil)
  n=n1
  if modulo(n1,4)<>0 then n=4*(int(n1/4)+1),end
  c=mget(n,'uc',ufil)
  if n1-1>size(c) then pause,end
  x=ascii(c(1:n1-1))
endfunction

function x=LoadVectS()
// Copyright INRIA
// Author: Serge Steer

// Emulate the C procedure in routines/graphics/RecLoad.c
  
  n=mget(1,'uib',ufil)
  x=[]
  for k=1:n
    x=[x;LoadC()]
  end
endfunction

function rec=plot2d_rec()
// Copyright INRIA
// Author: Serge Steer

  
  rec=tlist(['plot2d','n1','n2','name','xf','x','y','style','strflag',..
	     'strflag_kp','legend','brect','brect_kp','aint','aint_kp'])
endfunction

function rec=plot3d_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['plot3d','p','q','teta','alpha','name','x','y','z',..
	     'legend','flag','bbox'])
endfunction

function rec= xcall1_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['xcall1','fname' 'string' 'n1' 'n2' 'n3' 'n4' 'n5' 'n6',..
	     'ndx1' 'ndx2' 'ndx3' 'ndx4' 'x1' 'x2' 'x3' 'x4' 'x5' 'x6' ,..
	     'dx1' 'dx2' 'dx3' 'dx4'])
endfunction
function rec= xtitle_rec()
// Copyright INRIA
// Author: Serge Steer
  rec=tlist(['xtitle','strs'])
endfunction

function rec=scale_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['scale','logflag','name','Wrect','Frect','Frect_kp'])
endfunction

function rec=nscale_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['nscale','logflag','name','flag','Wrect','Frect','Arect','Frect_kp'])
endfunction

function rec=sciaxis_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['sciaxis','nx' 'ny' 'sub_int' 'fontsize' 'textcolor' ,..
	     'ticscolor' 'seg' 'f_l' 'name' 'format_n' 'x' 'y' 'str' ..
	     'dir' 'tics' 'logflag'])
endfunction

function rec=xgrid_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['xgrid','style','name'])
endfunction
function rec=param3d_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['param3d','n','teta' 'alpha' 'name',..
	     'x' 'y' 'z' 'legend' 'flag','bbox'])
endfunction

function rec=param3d1_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['param3d1','m','n','iflag','colors','teta' 'alpha' 'name',..
	     'x' 'y' 'z' 'legend' 'flag' 'bbox'])
endfunction

function rec=fac3d_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['fac3d','p','q','teta','alpha','name','cvect','x','y','z',..
	     'legend','flag','bbox'])
endfunction

function rec=fec_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['fec','Nnode','Ntr','name','x','y','triangles','func','brect',..
	     'brect_kp','aaint','aaint_kp','strflag','strflag_kp','legend',..
	    'zminmax','colminmax'])
endfunction

function rec=colormap_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['colormap','cmap'])
endfunction

function rec=contour_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['contour','n1','n2','nz','flagnz','zz','teta','alpha','zlev',..
	     'name','x','y','z','legend','flag','bbox'])
endfunction

function rec=contour2d_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['contour2d','n1','n2','nz','flagnz','zz',..
	     'name','x','y','z','style','strflag','strflag_kp','legend','brect',..
	     'brect_kp','aint','aint_kp'])
endfunction

function rec=gray_rec()
// Copyright INRIA
// Author: Serge Steer
   
  rec=tlist(['gray','n1','n2','name','x','y','z','style',..
	     'strflag','strflag_kp','legend','brect',..
	     'brect_kp','aint','aint_kp'])
endfunction

function rec=gray_rec_2()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['gray2','n1','n2','name','z','xrect'])
endfunction

function rec=champ_rec()
// Copyright INRIA
// Author: Serge Steer
  
  rec=tlist(['contour2d','n1','n2','arfact',..
	     'name','x','y','fx','fy','strflag','strflag_kp','vrect',..
	     'vrect_kp'])
endfunction

function txt=%xcall1_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  select rec.fname
    case 'xset' then
    txt='xset(""'+rec.string+'""'
    if or(rec.string==["alufunction","background","dashes","foreground",..
		       "hidden3d","line mode","pattern","pixmap","thickness",..
		       "use color","window","wresize","clipgrf","color",..
		       "line style"]) then
      txt=txt+','+string(rec.x1)+')'
    elseif or(rec.string==["default","wshow","wwpc","clipoff"]) then
      txt=txt+')'
    elseif or(rec.string==["font","mark","wdim","wpos","viewport"]) then
      txt=txt+','+string(rec.x1)+','+string(rec.x2)+')'
    elseif or(rec.string==["clipping"]) then
      txt=txt+','+string(rec.dx1)+','+string(rec.dx2)+','+string(rec.dx3)+..
	  ','+string(rec.dx4)+')'
    elseif or(rec.string==["auto clear"]) then  
      if rec.n1==1 then 
	txt=txt+',""on"")'
      else
	txt=txt+',""off"")'
      end
    else
      txt=txt+',???)'
    end
    case 'xrect' then
    txt='xrect('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+','+..
	sci2exp(rec.dx3,0)+','+sci2exp(rec.dx4,0)+')'
	sci2exp(rec.dx3,0)+','+sci2exp(rec.dx4,0)+')'
    case 'xrects' then	
    m=rec.ndx1
    txt=[sci2exp(matrix(rec.dx1,-1,4),'x')
	 'xrects(x)']
    case 'xfrect' then
    txt='xfrect('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+','+..
	sci2exp(rec.dx3,0)+','+sci2exp(rec.dx4,0)+')'
	sci2exp(rec.dx3,0)+','+sci2exp(rec.dx4,0)+')'
    case 'xpolys' then
    dr=sci2exp(rec.x3)
    m=rec.ndx1
    txt=[sci2exp(matrix(rec.dx1,m,-1),'x')
	 sci2exp(matrix(rec.dx2,m,-1),'y')
	 'xpolys(x,y,'+dr+')']
    case 'xstring' then
    txt='xstring('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+','+..
	sci2exp(rec.string,0)+','+sci2exp(rec.dx3,0)+')'
    case 'xstringb' then
    txt='xstringb('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+','+..
	sci2exp(rec.string,0)+','+sci2exp(rec.dx3,0)+','+sci2exp(rec.dx4,0)+')'

    case 'xsegs' then
    m=rec.ndx1
    style=sci2exp(rec.x1,0)
    txt=[sci2exp(matrix(rec.dx1,m,-1),'x',0)
	 sci2exp(matrix(rec.dx2,m,-1),'y',0)
	 'xsegs(x,y,'+style+')']
    case 'xarrow' then
    txt=[]
    case 'xarc' then
    txt='xarc('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+','+..
	sci2exp(rec.dx3,0)+','+sci2exp(rec.dx4,0)+','+..
	sci2exp(rec.x5,0)+','+sci2exp(rec.x6,0)+')'
    case 'xarcs' then
    n=rec.n3
    txt=[sci2exp(matrix(rec.dx1,6,-1),'arcs',0)
	 'xarcs(arcs,'+sci2exp(rec.x2,0)+')']
    case 'xfarc' then
        txt='xfarc('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+','+..
	    sci2exp(rec.dx3)+','+sci2exp(rec.dx4,0)+','+..
	    sci2exp(rec.x5,0)+','+sci2exp(rec.x6,0)+')'
    case 'xfarcs' then 
        txt=[sci2exp(matrix(rec.dx1,6,-1),'arcs',0)
	 'xfarcs(arcs,'+sci2exp(rec.x2,0)+')']
    case 'xaxis' then
        txt=['xaxis('+sci2exp(rec.dx1,0)+','+sci2exp(rec.x2,0)+','+..
	     sci2exp(rec.dx2,0)+','+sci2exp(rec.dx3,0)+')']
    case 'xlines' then
        txt=['xpoly('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+..
	     ',''lines'','+sci2exp(rec.x4,0)+')']
    case 'xarea' then
        txt=['xfpoly('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+..
	     ','+sci2exp(rec.x4,0)+')']
	    

    case 'xliness' then
    txt=['xpoly('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+..
	     ',''lines'','+sci2exp(rec.x4,0)+')']
	
    case 'xmarks' then
        txt=['xpoly('+sci2exp(rec.dx1,0)+','+sci2exp(rec.dx2,0)+..
	     ',''marks'','+sci2exp(rec.x4,0)+')']
  else
    error('%xcall1_string, unknown keyword: '+rec.fname)
  end
endfunction

function %xcall1_p(rec)
// Copyright INRIA
// Author: Serge Steer

  disp(string(rec))
endfunction

function txt=%xtitle_string(rec)
// Copyright INRIA
// Author: Serge Steer
  txt='xtitle('+sci2exp(rec.strs(1))+','+sci2exp(rec.strs(2))+','+..
      sci2exp(rec.strs(3))+')'
endfunction

function %xtitle_p(rec)
// Copyright INRIA
// Author: Serge Steer
  disp(%xtitle_string(rec))
endfunction


function txt=%plot2d_string(rec)
// Copyright INRIA
// Author: Serge Steer

  txt=[]
  n1=rec.n1
  n2=rec.n2

  rec.x=matrix(rec.x,n2,-1)
  txt=[txt;sci2exp(rec.x,'x')];txt($)=txt($)+';';x='x';

  rec.y=matrix(rec.y,n2,-1)
  txt=[txt;sci2exp(rec.y,'y')];txt($)=txt($)+';';y='y';

  txt=[txt;rec.name+'(""'+rec.xf+'"",'+x+','+y+','+sci2exp(rec.style)+',""'+..
       rec.strflag+'"",""'+rec.legend+'"",'+sci2exp(rec.brect)+','+..
       sci2exp(rec.aint)+')']
endfunction

function %plot2d_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%plot3d_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  txt=[]

  p=rec.p
  q=rec.q
  
  if size(rec.x,'*')<>p then rec.x=matrix(rec.x,p,q),end
  txt=[txt;sci2exp(rec.x,'x')]
  x='x'

  if size(rec.y,'*')<>p then rec.y=matrix(rec.y,p,q),end
  txt=[txt;sci2exp(rec.y,'y')]
  y='y'


  txt=[txt;sci2exp(matrix(rec.z,p,q),'z')]
  z='z'


  txt=[txt;rec.name+'('+x+','+y+','+z+','+sci2exp(rec.teta)+','+..
       sci2exp(rec.alpha)+',""'+rec.legend+'"",'+sci2exp(rec.flag)+','+..
       sci2exp(rec.bbox)+')']
endfunction

function %plot3d_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%fac3d_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  txt=[]

  p=rec.p
  q=rec.q

  rec.x=matrix(rec.x,p,q)
  txt=[txt;sci2exp(rec.x,'x')]
  x='x'

  rec.y=matrix(rec.y,p,q)
  txt=[txt;sci2exp(rec.y,'y')]
  y='y'

  txt=[txt;sci2exp(matrix(rec.z,p,q),'x')]
  z='z'

  txt=[txt;rec.name+'('+x+','+y+','+z+','+sci2exp(rec.teta)+','+..
       sci2exp(rec.alpha)+'""'+rec.legend+'"",'+sci2exp(rec.flag)+','+..
       sci2exp(rec.bbox)+')']
endfunction

function %fac3d_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction



function %SPLOT_p(rec)
// Copyright INRIA
// Author: Serge Steer
  for k=2:size(rec)
    disp(rec(k))
  end
endfunction

function txt=%SPLOT_string(rec)
// Copyright INRIA
// Author: Serge Steer
  txt=[]
  for k=2:size(rec)
    txt=[txt;string(rec(k))]
  end
endfunction

function txt=%nscale_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  txt=[]
  if rec.logflag=='n' then rec.logflag='nn',end
  logflag=sci2exp(rec.logflag,'logflag')
  wrect=sci2exp(rec.Wrect,'wrect')
  frect=sci2exp(rec.Frect,'frect')
  arect=sci2exp(rec.Arect,'arect')
  txt='xsetech('+strcat([wrect,frect,arect,logflag],',')+')'
endfunction

function %nscale_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%scale_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  txt=[]
  if rec.logflag=='n' then rec.logflag='nn',end
  logflag=sci2exp(rec.logflag,'logflag')
  wrect=sci2exp(rec.Wrect,'wrect')
  frect=sci2exp(rec.Frect,'frect')
  txt='xsetech('+strcat([wrect,frect,logflag],',')+')'
endfunction

function %scale_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction


function txt=%colormap_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  txt=[sci2exp(rec.cmap,'cmap')
      'xset('"colormap'",cmap)']
endfunction

function %colormap_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%sciaxis_string(rec)
 // Copyright INRIA
// Author: Serge Steer
 
  f=['x';'y';'dir';'sub_int';'tics']
  txt=[]
  args=[]
  for k=1:size(f,'*')
    if size(rec(f(k)),'*')==1 then
      args=[args sci2exp(rec(f(k)),f(k))]
    else
      txt=[txt;sci2exp(rec(f(k)),f(k))]
      args=[args f(k)+'='+f(k)]
    end
  end
  if rec.seg<>1 then
    args=[args sci2exp(rec.seg,'seg')],
  end
  if length(rec.format_n)>0 then
    args=[args sci2exp(rec.format_n,'format_n')]
  end
  if rec.textcolor<>-1 then
    args=[args sci2exp(rec.textcolor,'textcolor')],
  end
  if rec.ticscolor<>-1 then
    args=[args sci2exp(rec.ticscolor,'ticscolor')],
  end
  if rec.fontsize<>-1 then
    args=[args sci2exp(rec.fontsize,'fontsize')],
  end
 
  
  txt=[txt;'drawaxis('+strcat(args,',')+')']

endfunction

function %sciaxis_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%param3d_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  n=rec.n
  txt=[sci2exp(matrix(rec.x,n,-1),'x')
       sci2exp(matrix(rec.y,n,-1),'y')
       sci2exp(matrix(rec.z,n,-1),'z')]
  args=['x';'y';'z';sci2exp(rec.teta);sci2exp(rec.alpha);
	sci2exp(rec.legend);sci2exp(rec.flag(1:2)+1);sci2exp(rec.bbox)]
  
  txt=[txt;'param3d('+strcat(args,',')+')']
endfunction

function %param3d_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%param3d1_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  m=rec.m
  txt=[sci2exp(matrix(rec.x,m,-1),'x')
       sci2exp(matrix(rec.y,m,-1),'y')]
  if rec.iflag==0 then
    txt=[txt;sci2exp(matrix(rec.z,m,-1),'z')]
  else
    txt=[txt;sci2exp(list(matrix(rec.z,m,-1),rec.colors),'z')]
  end
  args=['x';'y';'z';sci2exp(rec.teta);sci2exp(rec.alpha);
	sci2exp(rec.legend);sci2exp(rec.flag(1:2)+1);sci2exp(rec.bbox)]
  
  txt=[txt;'param3d1('+strcat(args,',')+')']
endfunction

function %param3d1_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%contour2_string(rec)
// Copyright INRIA
// Author: Serge Steer
   
  if rec.name=='champ' then
  n1=rec.n1;
  txt=[sci2exp(rec.x,'x')
       sci2exp(rec.y,'y')
       sci2exp(matrix(rec.fx,n1,-1),'fx')
       sci2exp(matrix(rec.fy,n1,-1),'fy')]
  args=['x';'y';'fx';'fy';sci2exp(rec.arfact);sci2exp(rec.vrect);sci2exp(rec.strflag)]
   txt=[txt;
	rec.name+'('+strcat(args,',')+')']
  elseif rec.name=='contour2' then
    n1=rec.n1;
    txt=[sci2exp(rec.x,'x')
       sci2exp(rec.y,'y')
       sci2exp(matrix(rec.z,n1,-1),'z')]
    if rec.flagnz==0 then
      nz=sci2exp(rec.nz)
    else
      nz=sci2exp(rec.zz)
    end
     args=['x';'y';'z';nz;sci2exp(rec.style);
	   sci2exp(rec.strflag);sci2exp(rec.legend);sci2exp(rec.brect);
	   sci2exp(rec.aint)]
     txt=[txt;
	  'contour2d('+strcat(args,',')+')']
  else
    error('%contour2_string, unknown name: '+rec.name)
  end
endfunction

function %contour2_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%contour_string(rec)
// Copyright INRIA
// Author: Serge Steer
 
   n1=rec.n1;
    txt=[sci2exp(rec.x,'x')
       sci2exp(rec.y,'y')
       sci2exp(matrix(rec.z,n1,-1),'z')]
    if rec.flagnz==0 then
      nz=sci2exp(rec.nz)
    else
      nz=sci2exp(rec.zz)
    end
     args=['x';'y';'z';nz;sci2exp(rec.teta);
	   sci2exp(rec.alpha);
	   sci2exp(rec.legend);sci2exp(rec.flag);
	   sci2exp(rec.bbox);sci2exp(rec.zlev)]
     txt=[txt;
	  'contour('+strcat(args,',')+')']
  
endfunction

function %contour_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%fec_string(rec)
// Copyright INRIA
// Author: Serge Steer

  txt=[sci2exp(rec.x,'x')
       sci2exp(rec.y,'y')
       sci2exp(matrix(rec.triangles,-1,5),'triangles')
       sci2exp(rec.func,'func')]
  args=['x';'y';'triangles';'func';sci2exp(rec.strflag);
	sci2exp(rec.legend);sci2exp(rec.brect);sci2exp(rec.aaint);
	sci2exp(rec.zminmax);sci2exp(rec.colminmax)]
  txt=[txt;
       'fec('+strcat(args,',')+')']
endfunction

function %fec_p(rec)
// Copyright INRIA
// Author: Serge Steer
 
  disp(string(rec))
endfunction

function txt=%gray_string(rec)
// Copyright INRIA
// Author: Serge Steer
  
  n2=rec.n2
  if rec.name=='gray1' then
    txt=sci2exp(matrix(rec.z,-1,n2),'z')
    args=['z';sci2exp(rec.strflag);sci2exp(rec.brect);
	  sci2exp(rec.aint)]
    txt=[txt;
	 'Matplot('+strcat(args,',')+')']
  else
    txt=[sci2exp(rec.x,'x')
	 sci2exp(rec.y,'y')
	 sci2exp(matrix(rec.z,-1,n2),'z')]
    args=['x';'y';'z';sci2exp(rec.strflag);sci2exp(rec.brect);
	  sci2exp(rec.aint)]
    txt=[txt;
	 'grayplot('+strcat(args,',')+')']
  end
  
endfunction

function %gray_p(rec)
// Copyright INRIA
// Author: Serge Steer
  
  disp(string(rec))
endfunction

function txt=%gray2_string(rec)
// Copyright INRIA
// Author: Serge Steer

  n2=rec.n2
  txt=sci2exp(matrix(rec.z,-1,n2),'z')
  args=['z';sci2exp(rec.xrect)]
  txt=[txt;
       'Matplot1('+strcat(args,',')+')']
endfunction

function %gray2_p(rec)
// Copyright INRIA
// Author: Serge Steer
 
  disp(string(rec))
endfunction
function txt=%xgrid_string(rec)
// Copyright INRIA
// Author: Serge Steer
  txt='xgrid('+sci2exp(rec.style)+')'
endfunction

function %xgrid_p(rec)
// Copyright INRIA
// Author: Serge Steer
 
  disp(string(rec))
endfunction
