import matplotlib.pyplot as plt
numargs = chi2.numargs
[ df ] = [0.9,] * numargs
rv = chi2(df)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = chi2.cdf(x, df)
h = plt.semilogy(np.abs(x - chi2.ppf(prb, df)) + 1e-20)

# Random number generation

R = chi2.rvs(df, size=100)
